/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.exception;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.spi.AlertEntity;
import com.dianping.cat.alarm.spi.AlertManager;
import com.dianping.cat.alarm.spi.AlertType;
import com.dianping.cat.consumer.top.model.IVisitor;
import com.dianping.cat.consumer.top.model.entity.TopReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.alert.exception.AlertExceptionBuilder;
import com.dianping.cat.report.alert.exception.ExceptionRuleConfigManager;
import com.dianping.cat.report.page.dependency.TopExceptionExclude;
import com.dianping.cat.report.page.dependency.TopMetric;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class ExceptionAlert
implements Threads.Task {
    protected static final long DURATION = 60000L;
    protected static final int ALERT_PERIOD = 1;
    @Inject
    protected ExceptionRuleConfigManager m_exceptionConfigManager;
    @Inject
    protected AlertExceptionBuilder m_alertBuilder;
    @Inject(type=ModelService.class, value={"top"})
    protected ModelService<TopReport> m_topService;
    @Inject
    protected AlertManager m_sendManager;

    protected TopMetric buildTopMetric(Date date) {
        TopReport topReport = this.queryTopReport(date);
        TopMetric topMetric = new TopMetric(1, Integer.MAX_VALUE, this.m_exceptionConfigManager);
        topMetric.setStart(date).setEnd(new Date(date.getTime() + 60000L));
        topMetric.visitTopReport(topReport);
        return topMetric;
    }

    public String getName() {
        return AlertType.Exception.getName();
    }

    private void handleExceptions(List<TopMetric.Item> itemList) {
        Map alertExceptions = this.m_alertBuilder.buildAlertExceptions(itemList);
        for (Map.Entry entry : alertExceptions.entrySet()) {
            try {
                String domain = (String)entry.getKey();
                List exceptions = (List)entry.getValue();
                for (AlertExceptionBuilder.AlertException exception : exceptions) {
                    String metricName = exception.getName();
                    AlertEntity entity = new AlertEntity();
                    entity.setDate(new Date()).setContent(exception.toString()).setLevel(exception.getType());
                    entity.setMetric(metricName).setType(this.getName()).setGroup(domain);
                    this.m_sendManager.addAlert(entity);
                }
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
    }

    protected TopReport queryTopReport(Date start) {
        String domain = "cat";
        String date = String.valueOf(start.getTime());
        ModelRequest request = new ModelRequest(domain, start.getTime()).setProperty("date", date);
        if (this.m_topService.isEligable(request)) {
            ModelResponse response = this.m_topService.invoke(request);
            TopReport report = (TopReport)response.getModel();
            report.accept((IVisitor)new TopExceptionExclude(this.m_exceptionConfigManager));
            return report;
        }
        throw new RuntimeException("Internal error: no eligable top service registered for " + request + "!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            long current = System.currentTimeMillis();
            Transaction t = Cat.newTransaction((String)"AlertException", (String)TimeHelper.getMinuteStr());
            try {
                TopMetric topMetric = this.buildTopMetric(new Date(current - 120000L));
                Collection itemLists = topMetric.getError().getResult().values();
                List itemList = new ArrayList();
                if (!itemLists.isEmpty()) {
                    itemList = (List)itemLists.iterator().next();
                }
                ArrayList<TopMetric.Item> items = new ArrayList<TopMetric.Item>();
                for (TopMetric.Item item : itemList) {
                    if ("FrontEnd".equals(item.getDomain())) continue;
                    items.add(item);
                }
                this.handleExceptions(items);
                t.setStatus("0");
            }
            catch (Exception e) {
                t.setStatus((Throwable)e);
            }
            finally {
                t.complete();
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 60000L) continue;
                Thread.sleep(60000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

