/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.heartbeat;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.spi.AlertEntity;
import com.dianping.cat.alarm.spi.AlertType;
import com.dianping.cat.alarm.spi.decorator.Decorator;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class HeartbeatDecorator
extends Decorator
implements Initializable {
    public static final String ID = AlertType.HeartBeat.getName();
    public Configuration m_configuration;

    public String generateContent(AlertEntity alert) {
        try {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("domain", alert.getDomain());
            dataMap.put("date", this.m_format.format(alert.getDate()));
            dataMap.put("metric", alert.getMetric());
            String[] business = alert.getContent().split("<br/>");
            ArrayList<String> strs = new ArrayList<String>(Arrays.asList(business));
            dataMap.put("heartBeat", strs);
            dataMap.put("ip", alert.getParas().get("ip"));
            StringWriter sw = new StringWriter(5000);
            try {
                Template t = this.m_configuration.getTemplate("heartbeatAlertMarkdown.ftl");
                t.process(dataMap, (Writer)sw);
            }
            catch (Exception e) {
                Cat.logError((String)("build heartbeatAlertMarkdown content error:" + alert.toString()), (Throwable)e);
            }
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            Cat.logError((Throwable)e);
            return this.generateTitle(alert) + "" + alert.getContent();
        }
    }

    public String generateTitle(AlertEntity alert) {
        StringBuilder sb = new StringBuilder();
        sb.append("[\u5fc3\u8df3\u544a\u8b66][\u9879\u76ee:").append(alert.getGroup()).append("][ip: ").append(alert.getParas().get("ip")).append("][\u6307\u6807: ").append(alert.getMetric()).append("]");
        return sb.toString();
    }

    public String getId() {
        return ID;
    }

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(this.getClass(), "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

