/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.spi;

import com.dianping.cat.alarm.rule.entity.Condition;
import com.dianping.cat.alarm.rule.entity.Config;
import com.dianping.cat.helper.MetricType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unidal.lookup.util.StringUtils;

public class AlarmRule {
    private Map<String, Map<MetricType, List<Config>>> m_configs;

    public AlarmRule(Map<String, Map<MetricType, List<Config>>> configs) {
        this.m_configs = configs;
    }

    public int calMaxRuleMinute() {
        int maxMinute = 0;
        for (Map subMap : this.m_configs.values()) {
            for (List tmpConfigs : subMap.values()) {
                for (Config config : tmpConfigs) {
                    for (Condition condition : config.getConditions()) {
                        int tmpMinute = condition.getMinute();
                        if (tmpMinute <= maxMinute) continue;
                        maxMinute = tmpMinute;
                    }
                }
            }
        }
        return maxMinute;
    }

    public List<Map<MetricType, List<Config>>> findDetailRules(String metricName) {
        ArrayList<Map<MetricType, List<Config>>> arrays = new ArrayList<Map<MetricType, List<Config>>>();
        for (Map.Entry entry : this.m_configs.entrySet()) {
            String metricPattern = (String)entry.getKey();
            if (this.validateRegex(metricPattern, metricName) <= 0) continue;
            arrays.add((Map<MetricType, List<Config>>)entry.getValue());
        }
        return arrays;
    }

    public Map<String, Map<MetricType, List<Config>>> getConfigs() {
        return this.m_configs;
    }

    public void setConfigs(Map<String, Map<MetricType, List<Config>>> configs) {
        this.m_configs = configs;
    }

    public int validateRegex(String regexText, String text) {
        if (StringUtils.isEmpty((String)regexText)) {
            return 1;
        }
        if (regexText.equalsIgnoreCase(text)) {
            return 3;
        }
        Pattern p = Pattern.compile(regexText);
        Matcher m = p.matcher(text);
        if (m.find()) {
            return 2;
        }
        return 0;
    }
}

