/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.spi.config;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.rule.entity.Condition;
import com.dianping.cat.alarm.rule.entity.MetricItem;
import com.dianping.cat.alarm.rule.entity.MonitorRules;
import com.dianping.cat.alarm.rule.entity.Rule;
import com.dianping.cat.alarm.rule.entity.SubCondition;
import com.dianping.cat.alarm.rule.transform.DefaultJsonParser;
import com.dianping.cat.alarm.rule.transform.DefaultSaxParser;
import com.dianping.cat.alarm.spi.rule.RuleType;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.helper.MetricType;
import com.dianping.cat.report.alert.config.BaseRuleHelper;
import com.dianping.cat.report.alert.spi.AlarmRule;
import com.dianping.cat.report.alert.spi.config.UserDefinedRuleManager;
import com.dianping.cat.task.TimerSyncTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;
import org.xml.sax.SAXException;

public abstract class BaseRuleConfigManager {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    protected UserDefinedRuleManager m_manager;
    @Inject
    protected BaseRuleHelper m_helper;
    @Inject
    protected ContentFetcher m_fetcher;
    protected int m_configId;
    protected MonitorRules m_config;
    private long m_modifyTime;

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(this.getConfigName(), ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(this.getConfigName());
                Config config = this.m_configDao.createLocal();
                config.setName(this.getConfigName());
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new MonitorRules();
        }
        this.registerHandler();
    }

    private void registerHandler() {
        TimerSyncTask.getInstance().register((TimerSyncTask.SyncHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(this.getConfigName(), ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        BaseRuleConfigManager baseRuleConfigManager = this;
        synchronized (baseRuleConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                String content = config.getContent();
                this.m_config = DefaultSaxParser.parse((String)content);
                this.m_modifyTime = modifyTime;
            }
        }
    }

    private int calMaxNum(Set<Integer> nums) {
        int max = 0;
        for (int n : nums) {
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    public Pair<Integer, List<Condition>> convertConditions(List<com.dianping.cat.alarm.rule.entity.Config> configs) {
        return this.m_helper.convertConditions(configs);
    }

    private Rule copyRule(Rule rule) {
        try {
            return (Rule)DefaultSaxParser.parseEntity(Rule.class, (String)rule.toString());
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    private void decorateConfigOnDelete(List<com.dianping.cat.alarm.rule.entity.Config> configs) {
        for (com.dianping.cat.alarm.rule.entity.Config config : configs) {
            for (Condition condition : config.getConditions()) {
                for (SubCondition subCondition : condition.getSubConditions()) {
                    if (!RuleType.UserDefine.getId().equals(subCondition.getType())) continue;
                    try {
                        String id = subCondition.getText();
                        this.m_manager.removeById(id);
                    }
                    catch (DalException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
        }
    }

    private List<com.dianping.cat.alarm.rule.entity.Config> decorateConfigOnRead(List<com.dianping.cat.alarm.rule.entity.Config> originConfigs) {
        List configs = this.deepCopy(originConfigs);
        for (com.dianping.cat.alarm.rule.entity.Config config : configs) {
            for (Condition condition : config.getConditions()) {
                for (SubCondition subCondition : condition.getSubConditions()) {
                    if (!RuleType.UserDefine.getId().equals(subCondition.getType())) continue;
                    try {
                        String id = subCondition.getText();
                        subCondition.setText(this.m_manager.getUserDefineText(id));
                    }
                    catch (DalException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
        }
        return configs;
    }

    private Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>> decorateConfigOnRead(Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>> originConfigs) {
        HashMap<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>> configs = new HashMap<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>();
        for (Map.Entry<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>> originConfig : originConfigs.entrySet()) {
            configs.put(originConfig.getKey(), this.decorateConfigOnRead(originConfig.getValue()));
        }
        return configs;
    }

    private void decorateConfigOnStore(List<com.dianping.cat.alarm.rule.entity.Config> configs) throws DalException {
        for (com.dianping.cat.alarm.rule.entity.Config config : configs) {
            for (Condition condition : config.getConditions()) {
                for (SubCondition subCondition : condition.getSubConditions()) {
                    if (!RuleType.UserDefine.getId().equals(subCondition.getType())) continue;
                    try {
                        String userDefinedText = subCondition.getText();
                        subCondition.setText(this.m_manager.addUserDefineText(userDefinedText));
                    }
                    catch (DalException e) {
                        Cat.logError((Throwable)e);
                    }
                }
            }
        }
    }

    private List<com.dianping.cat.alarm.rule.entity.Config> deepCopy(List<com.dianping.cat.alarm.rule.entity.Config> originConfigs) {
        ArrayList<com.dianping.cat.alarm.rule.entity.Config> result = new ArrayList<com.dianping.cat.alarm.rule.entity.Config>();
        for (com.dianping.cat.alarm.rule.entity.Config config : originConfigs) {
            try {
                com.dianping.cat.alarm.rule.entity.Config copiedConfig = (com.dianping.cat.alarm.rule.entity.Config)DefaultSaxParser.parseEntity(com.dianping.cat.alarm.rule.entity.Config.class, (String)config.toString());
                result.add(copiedConfig);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        return result;
    }

    public String deleteRule(String key) {
        Rule rule = (Rule)this.m_config.getRules().get(key);
        if (rule != null) {
            this.decorateConfigOnDelete(rule.getConfigs());
            this.m_config.getRules().remove(key);
        }
        return this.m_config.toString();
    }

    private void extractConfigsByProduct(String product, Rule rule, Map<String, Map<Integer, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>>> configs) {
        List items = rule.getMetricItems();
        for (MetricItem item : items) {
            String configProduct = item.getProductText();
            String configMetricKey = item.getMetricItemText();
            int matchLevel = this.validateRegex(configProduct, product);
            if (matchLevel <= 0) continue;
            Map<Integer, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>> configsByPriority = configs.get(configMetricKey);
            if (configsByPriority == null) {
                configsByPriority = new HashMap<Integer, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>>();
                configs.put(configMetricKey, configsByPriority);
            }
            HashMap<MetricType, List> configsByType = new HashMap<MetricType, List>();
            if (item.isMonitorAvg()) {
                configsByType.put(MetricType.AVG, rule.getConfigs());
            }
            if (item.isMonitorCount()) {
                configsByType.put(MetricType.COUNT, rule.getConfigs());
            }
            if (item.isMonitorSum()) {
                configsByType.put(MetricType.SUM, rule.getConfigs());
            }
            configsByPriority.put(matchLevel, configsByType);
        }
    }

    private Map<String, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>> extractMaxPriorityConfigs(Map<String, Map<Integer, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>>> configs) {
        HashMap<String, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>> result = new HashMap<String, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>>();
        for (Map.Entry<String, Map<Integer, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>>> entry : configs.entrySet()) {
            String metric = entry.getKey();
            Map<Integer, Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>>> priorityMap = entry.getValue();
            int maxPriority = this.calMaxNum(priorityMap.keySet());
            Map<MetricType, List<com.dianping.cat.alarm.rule.entity.Config>> configsByType = priorityMap.get(maxPriority);
            result.put(metric, this.decorateConfigOnRead(configsByType));
            Cat.logEvent((String)("FindRule:" + this.getConfigName()), (String)metric, (String)"0", null);
        }
        return result;
    }

    protected abstract String getConfigName();

    protected List<Rule> getMaxPriorityRules(Map<Integer, List<Rule>> rules) {
        Set<Integer> keys = rules.keySet();
        int maxKey = 0;
        for (int key : keys) {
            if (key <= maxKey) continue;
            maxKey = key;
        }
        List<Rule> finalRules = rules.get(maxKey);
        if (finalRules == null) {
            finalRules = new ArrayList<Rule>();
        }
        return finalRules;
    }

    public MonitorRules getMonitorRules() {
        return this.m_config;
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public AlarmRule queryConfigs(String product) {
        HashMap configs = new HashMap();
        for (Rule rule : this.m_config.getRules().values()) {
            this.extractConfigsByProduct(product, rule, configs);
        }
        Map maxPriority = this.extractMaxPriorityConfigs(configs);
        return new AlarmRule(maxPriority);
    }

    public Rule queryRule(String key) {
        Rule rule = (Rule)this.m_config.getRules().get(key);
        if (rule != null) {
            return this.copyRule(rule);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean storeConfig() {
        BaseRuleConfigManager baseRuleConfigManager = this;
        synchronized (baseRuleConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(this.getConfigName());
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public String updateRule(String id, String metricsStr, String configsStr) throws Exception {
        Rule rule = new Rule(id);
        List metricItems = DefaultJsonParser.parseArray(MetricItem.class, (String)metricsStr);
        List configs = DefaultJsonParser.parseArray(com.dianping.cat.alarm.rule.entity.Config.class, (String)configsStr);
        for (MetricItem metricItem : metricItems) {
            rule.addMetricItem(metricItem);
        }
        for (com.dianping.cat.alarm.rule.entity.Config config : configs) {
            rule.addConfig(config);
        }
        this.decorateConfigOnStore(rule.getConfigs());
        this.m_config.getRules().put(id, rule);
        return this.m_config.toString();
    }

    public int validate(String productText, String metricKeyText, String product, String metricKey) {
        int metricMatchResult;
        int groupMatchResult = this.validateRegex(productText, product);
        if (groupMatchResult > 0 && (metricMatchResult = this.validateRegex(metricKeyText, metricKey)) > 0) {
            return groupMatchResult;
        }
        return 0;
    }

    public int validateRegex(String regexText, String text) {
        if (StringUtils.isEmpty((String)regexText)) {
            return 1;
        }
        if (regexText.equalsIgnoreCase(text)) {
            return 3;
        }
        Pattern p = Pattern.compile(regexText);
        Matcher m = p.matcher(text);
        if (m.find()) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ void access$000(BaseRuleConfigManager x0) throws DalException, SAXException, IOException {
        x0.refreshConfig();
    }
}

