/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.summary.build;

import com.dianping.cat.alarm.spi.AlertType;
import com.dianping.cat.home.alert.summary.entity.Alert;
import com.dianping.cat.home.alert.summary.entity.AlertSummary;
import com.dianping.cat.home.alert.summary.entity.Category;
import com.dianping.cat.home.alert.summary.transform.BaseVisitor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AlertSummaryVisitor
extends BaseVisitor {
    public static final String LONG_CALL_NAME = "\u8d85\u65f6\u4f9d\u8d56\u8c03\u7528";
    private Map<Object, Object> m_result = new HashMap();
    private Map<Object, Object> m_categoryMap = new LinkedHashMap();
    private List<Map<Object, Object>> m_alertList;
    private DateFormat m_fmt = new SimpleDateFormat("HH:mm");
    private String m_domain;

    public AlertSummaryVisitor(String domain) {
        this.m_domain = domain;
    }

    private String convertNameToChinese(String name) {
        if (name.equals(AlertType.Business.getName())) {
            return "\u4e1a\u52a1\u544a\u8b66";
        }
        if (name.equals(AlertType.Exception.getName())) {
            return "\u5f02\u5e38\u544a\u8b66";
        }
        if (name.equals("long_call")) {
            return LONG_CALL_NAME;
        }
        if (name.equals("dependency_" + AlertType.Exception.getName())) {
            return "\u4f9d\u8d56\u5f02\u5e38\u544a\u8b66";
        }
        return "";
    }

    public Map<Object, Object> getResult() {
        return this.m_result;
    }

    public void visitAlert(Alert alert) {
        HashMap<String, Object> tmpALertMap = new HashMap<String, Object>();
        String alertDomain = alert.getDomain();
        if (alertDomain != null && alertDomain.equals(this.m_domain)) {
            tmpALertMap.put("metric", alert.getMetric());
        } else {
            tmpALertMap.put("metric", alertDomain + "<br>" + alert.getMetric());
        }
        tmpALertMap.put("domain", alert.getDomain());
        tmpALertMap.put("dateStr", this.m_fmt.format(alert.getAlertTime()));
        tmpALertMap.put("type", alert.getType());
        tmpALertMap.put("context", alert.getContext());
        tmpALertMap.put("count", alert.getCount());
        this.m_alertList.add(tmpALertMap);
    }

    public void visitAlertSummary(AlertSummary alertSummary) {
        Date date = alertSummary.getAlertDate();
        this.m_result.put("domain", alertSummary.getDomain());
        this.m_result.put("dateStr", this.m_fmt.format(date));
        this.m_result.put("categories", this.m_categoryMap);
        for (Category category : alertSummary.getCategories().values()) {
            this.visitCategory(category);
        }
    }

    public void visitCategory(Category category) {
        this.m_alertList = new ArrayList();
        for (Alert alert : category.getAlerts()) {
            this.visitAlert(alert);
        }
        this.m_categoryMap.put(this.convertNameToChinese(category.getName()), this.m_alertList);
    }
}

