/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.alert.transaction;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.spi.AlertEntity;
import com.dianping.cat.alarm.spi.AlertType;
import com.dianping.cat.alarm.spi.decorator.Decorator;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class TransactionDecorator
extends Decorator
implements Initializable {
    public static final String ID = AlertType.Transaction.getName();
    public Configuration m_configuration;
    protected DateFormat m_linkFormat = new SimpleDateFormat("yyyyMMddHH");

    public String generateContent(AlertEntity alert) {
        try {
            HashMap<String, Object> datas = new HashMap<String, Object>();
            String[] fields = alert.getMetric().split("-");
            datas.put("domain", alert.getGroup());
            datas.put("type", fields[0]);
            datas.put("name", fields[1]);
            datas.put("content", alert.getContent());
            String[] content = alert.getContent().split("<br/>");
            ArrayList<String> strs = new ArrayList<String>(Arrays.asList(content));
            datas.put("transactions", strs);
            datas.put("date", this.m_format.format(alert.getDate()));
            datas.put("linkDate", this.m_linkFormat.format(alert.getDate()));
            StringWriter sw = new StringWriter(5000);
            Template t = this.m_configuration.getTemplate("transactionAlert.ftl");
            t.process(datas, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            Cat.logError((String)("build front end content error:" + alert.toString()), (Throwable)e);
            return this.generateTitle(alert);
        }
    }

    public String generateTitle(AlertEntity alert) {
        StringBuilder sb = new StringBuilder();
        sb.append("[Transaction\u544a\u8b66] [\u9879\u76ee: ").append(alert.getGroup()).append("] [\u76d1\u63a7\u9879: ").append(alert.getMetric()).append("]");
        return sb.toString();
    }

    public String getId() {
        return ID;
    }

    public void initialize() throws InitializationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setDefaultEncoding("UTF-8");
        try {
            this.m_configuration.setClassForTemplateLoading(this.getClass(), "/freemaker");
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

