/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.graph;

import com.dianping.cat.helper.JsonBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LineChart {
    private transient SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private int m_size;
    private long m_step;
    private String m_start;
    private List<String> m_subTitles = new ArrayList();
    private String m_title;
    private String m_unit = "Value/\u5206\u949f";
    private String m_id;
    private String m_htmlTitle;
    private List<double[]> m_values = new ArrayList();
    private List<Double[]> m_valueObjects = new ArrayList();
    private List<Map<Long, Double>> m_datas = new ArrayList();
    private double[] m_ylabel;
    private Double m_minYlabel = 0.0;
    private Double m_maxYlabel;
    private long m_minTickInterval;
    private boolean m_yEnabled = true;

    public LineChart add(String title, Double[] value) {
        this.m_subTitles.add(title);
        this.m_valueObjects.add(value);
        return this;
    }

    public LineChart add(String title, Map<Long, Double> data) {
        this.m_datas.add(data);
        this.m_subTitles.add(title);
        return this;
    }

    public LineChart addSubTitle(String title) {
        this.m_subTitles.add(title);
        return this;
    }

    public LineChart addValue(double[] value) {
        this.m_values.add(value);
        return this;
    }

    public List<Map<Long, Double>> getDatas() {
        return this.m_datas;
    }

    public LineChart setDatas(List<Map<Long, Double>> datas) {
        this.m_datas = datas;
        return this;
    }

    public String getHtmlTitle() {
        if (this.m_htmlTitle == null) {
            return this.m_title;
        }
        return this.m_htmlTitle;
    }

    public LineChart setHtmlTitle(String htmlTitle) {
        this.m_htmlTitle = htmlTitle;
        return this;
    }

    public String getId() {
        return this.m_id;
    }

    public LineChart setId(String id) {
        this.m_id = id;
        return this;
    }

    public String getJsonString() {
        String json = new JsonBuilder().toJson((Object)this);
        return json;
    }

    public Double getMaxYlabel() {
        return this.m_maxYlabel;
    }

    public LineChart setMaxYlabel(Double maxYlabel) {
        this.m_maxYlabel = maxYlabel;
        return this;
    }

    public Double getMinYlable() {
        return this.m_minYlabel;
    }

    public LineChart setMinYlable(Double minYlable) {
        this.m_minYlabel = minYlable;
        return this;
    }

    public int getSize() {
        return this.m_size;
    }

    public LineChart setSize(int size) {
        this.m_size = size;
        return this;
    }

    public String getStart() {
        return this.m_start;
    }

    public LineChart setStart(Date start) {
        this.m_start = this.m_sdf.format(start);
        return this;
    }

    public long getStep() {
        return this.m_step;
    }

    public LineChart setStep(long step) {
        this.m_step = step;
        return this;
    }

    public List<String> getSubTitles() {
        return this.m_subTitles;
    }

    public LineChart setSubTitles(List<String> subTitles) {
        this.m_subTitles = subTitles;
        return this;
    }

    public String getTitle() {
        return this.m_title;
    }

    public LineChart setTitle(String title) {
        this.m_title = title;
        return this;
    }

    public String getUnit() {
        return this.m_unit;
    }

    public LineChart setUnit(String unit) {
        this.m_unit = unit;
        return this;
    }

    public List<Double[]> getValueObjects() {
        return this.m_valueObjects;
    }

    public List<double[]> getValues() {
        return this.m_values;
    }

    public LineChart setValues(List<double[]> values) {
        this.m_values = values;
        return this;
    }

    public double[] getValues(int index) {
        int size = this.m_values.size();
        if (index > size) {
            return null;
        }
        return (double[])this.m_values.get(index);
    }

    public double[] getYlable() {
        return this.m_ylabel;
    }

    public LineChart setYlable(double[] ylable) {
        this.m_ylabel = ylable == null ? new double[0] : Arrays.copyOf(ylable, ylable.length);
        return this;
    }

    public boolean isyEnabled() {
        return this.m_yEnabled;
    }

    public void setyEnabled(boolean yEnabled) {
        this.m_yEnabled = yEnabled;
    }

    public long getMinTickInterval() {
        return this.m_minTickInterval;
    }

    public void setMinTickInterval(long minTickInterval) {
        this.m_minTickInterval = minTickInterval;
    }

    public double queryMinYlable(Map<String, Double[]> datas) {
        double min = Double.MAX_VALUE;
        for (Double[] data : datas.values()) {
            List<Double> dataList;
            double tmp;
            if (data.length <= 0 || !(min > (tmp = Collections.min(dataList = Arrays.asList(data)).doubleValue()))) continue;
            min = tmp;
        }
        return min;
    }

    public double queryMinYlable(double[] datas) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < datas.length; ++i) {
            if (!(datas[i] < min)) continue;
            min = datas[i];
        }
        return min;
    }

    public String toString() {
        return new JsonBuilder().toJson((Object)this);
    }
}

