/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.graph.metric.impl;

import com.dianping.cat.report.graph.metric.DataExtractor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.lookup.annotation.Named;

@Named(type=DataExtractor.class)
public class DataExtractorImpl
implements DataExtractor {
    private static final int MIN_POINT_NUMBER = 60;
    private static final int MAX_POINT_NUMBER = 180;
    private int m_step;

    public int calculateInterval(int length) {
        int[] values;
        for (int value : values = new int[]{1, 2, 3, 6, 10, 20, 30, 60}) {
            int pm = length / value;
            if (pm < 60 || pm >= 180) continue;
            return value;
        }
        int pm = length / 60;
        if (pm > 180) {
            return 60;
        }
        return 1;
    }

    public double[] extract(double[] values) {
        int length = values.length;
        this.m_step = this.calculateInterval(length);
        int size = length / this.m_step;
        if (size * this.m_step < length) {
            ++size;
        }
        double[] result = new double[size];
        for (int i = 0; i < length; i += this.m_step) {
            double sum = 0.0;
            for (int j = 0; j < this.m_step; ++j) {
                if (i + j > length - 1) continue;
                sum += values[i + j];
            }
            result[i / this.m_step] = sum / (double)this.m_step;
        }
        return result;
    }

    public Map<String, double[]> extract(Map<String, double[]> values) {
        LinkedHashMap<String, double[]> result = new LinkedHashMap<String, double[]>();
        for (Map.Entry<String, double[]> entry : values.entrySet()) {
            result.put(entry.getKey(), this.extract(entry.getValue()));
        }
        return result;
    }

    public int getStep() {
        return this.m_step;
    }
}

