/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.graph.svg;

import com.dianping.cat.report.graph.svg.ValueTranslater;
import org.unidal.lookup.annotation.Named;

@Named(type=ValueTranslater.class)
public class DefaultValueTranslater
implements ValueTranslater {
    public double getMaxValue(double[] values) {
        double maxValue;
        double min = 2.147483647E9;
        double max = -2.147483648E9;
        for (double value : values) {
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        double maxLog = Math.log10(max);
        if (max > 0.0) {
            for (maxValue = Math.pow(10.0, Math.ceil(maxLog)); maxValue >= max * 2.0; maxValue /= 2.0) {
            }
        }
        return maxValue;
    }

    public int[] translate(int height, double maxValue, double[] values) {
        int len = values.length;
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            double value = values[i];
            double temp = value * (double)height / maxValue;
            if (temp > 0.0 && temp < 1.0) {
                temp = 1.0;
            }
            result[i] = (int)temp;
        }
        return result;
    }
}

