/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page;

import com.alibaba.fastjson.JSONObject;
import com.dianping.cat.Cat;
import com.dianping.cat.consumer.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SsoFilter
implements Filter {
    private String m_sso_auth = "http://sso.duiba.com.cn/sso/auth/authLogin?sso_ticket=";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpRequest.setCharacterEncoding("utf-8");
        String sso = this.getSsoTicket("sso_ticket", httpRequest, httpResponse);
        if (StringUtils.isNotEmpty((String)sso) && this.ssoAuth(httpRequest, httpResponse, sso)) {
            chain.doFilter(request, response);
        } else {
            Cat.logEvent((String)"SSOFilter", (String)"not login");
            this.noPermission(httpResponse);
        }
    }

    private void noPermission(HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        response.setContentType("application/json; charset=utf-8");
        response.setCharacterEncoding("UTF-8");
        JSONObject json = new JSONObject();
        json.put("success", (Object)false);
        json.put("message", (Object)"not login,please login sso first");
        out.print(json.toJSONString());
        out.flush();
        out.close();
    }

    private String getSsoTicket(String name, HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        String ticket = null;
        if (cookies != null) {
            for (Cookie ck : cookies) {
                if (!ck.getName().equalsIgnoreCase(name)) continue;
                ticket = ck.getValue();
                break;
            }
        }
        if (StringUtils.isNotEmpty((String)request.getQueryString())) {
            String[] arr;
            for (String str : arr = request.getQueryString().split("&")) {
                String[] args = str.split("=");
                String key = args[0];
                if (!"tick".equalsIgnoreCase(key)) continue;
                ticket = args.length > 1 ? args[1] : null;
                Cookie cookie = new Cookie("sso_ticket", ticket);
                cookie.setMaxAge(86400);
                cookie.setPath("/");
                response.addCookie(cookie);
                break;
            }
        }
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ssoAuth(HttpServletRequest request, HttpServletResponse response, String ticket) {
        Object session = request.getSession().getAttribute("sso_ticket");
        if (session != null && ticket.equalsIgnoreCase(session.toString())) {
            return true;
        }
        String result = "";
        BufferedReader in = null;
        try {
            boolean success;
            String line;
            String env = "dev";
            if (request.getRequestURL().toString().contains("console.dui88.com")) {
                env = "prod";
            }
            URL realUrl = new URL(this.m_sso_auth + ticket + "&environment=" + env);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36");
            connection.setConnectTimeout(50000);
            connection.setReadTimeout(50000);
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
            JSONObject obj = JSONObject.parseObject((String)result);
            boolean bl = success = obj.getBoolean("success") == null ? false : obj.getBoolean("success");
            if (success) {
                request.getSession().setAttribute("sso_ticket", (Object)ticket);
                request.getSession().setMaxInactiveInterval(3600);
                Cat.logEvent((String)"SSOFilter", (String)"login success");
            }
            boolean bl2 = success;
            return bl2;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            Cat.logError((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
    }
}

