/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.alteration;

import com.dianping.cat.Cat;
import com.dianping.cat.home.dal.report.Alteration;
import com.dianping.cat.home.dal.report.AlterationDao;
import com.dianping.cat.home.dal.report.AlterationEntity;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.alteration.Action;
import com.dianping.cat.report.page.alteration.Context;
import com.dianping.cat.report.page.alteration.Handler;
import com.dianping.cat.report.page.alteration.JspViewer;
import com.dianping.cat.report.page.alteration.Model;
import com.dianping.cat.report.page.alteration.Payload;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    private static final String EMPTY = "N/A";
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private AlterationDao m_alterationDao;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private Alteration buildAlteration(Payload payload) {
        String type = payload.getType();
        String domain = payload.getDomain();
        String hostname = payload.getHostname();
        String title = payload.getTitle();
        String ip = payload.getIp();
        String user = payload.getUser();
        String group = payload.getGroup();
        String content = payload.getContent();
        String url = payload.getUrl();
        int status = payload.getStatus();
        Date date = payload.getAlterationDate();
        Alteration alt = new Alteration();
        alt.setType(type);
        alt.setDomain(domain);
        alt.setTitle(title);
        alt.setIp(ip);
        alt.setUser(user);
        alt.setAltGroup(group);
        alt.setContent(content);
        alt.setHostname(hostname);
        alt.setDate(date);
        alt.setStatus(status);
        try {
            alt.setUrl(URLDecoder.decode(url, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Cat.logError((Throwable)e);
            alt.setUrl("");
        }
        return alt;
    }

    private Map<String, AlterationMinute> generateAlterationMinutes(List<Alteration> alts) {
        LinkedHashMap<String, AlterationMinute> alterationMinutes = new LinkedHashMap<String, AlterationMinute>();
        SimpleDateFormat df = new SimpleDateFormat("MM-dd HH:mm");
        for (Alteration alt : alts) {
            Date date = alt.getDate();
            String dateStr = df.format(date);
            AlterationMinute alterationMinute = (AlterationMinute)alterationMinutes.get(dateStr);
            if (alterationMinute == null) {
                alterationMinute = new AlterationMinute(dateStr);
                alterationMinutes.put(dateStr, alterationMinute);
            }
            alterationMinute.add(alt);
        }
        return alterationMinutes;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="alteration")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="alteration")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        switch (1.$SwitchMap$com$dianping$cat$report$page$alteration$Action[action.ordinal()]) {
            case 1: {
                if (this.isIllegalArgs(payload)) {
                    this.setInsertResult(model, 2);
                    break;
                }
                Alteration alt = this.buildAlteration(payload);
                try {
                    int count = this.m_alterationDao.insert(alt);
                    if (count == 0) {
                        this.setInsertResult(model, 1);
                        break;
                    }
                    this.setInsertResult(model, 0);
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                    this.setInsertResult(model, 1);
                }
                break;
            }
            case 2: {
                List alts = new ArrayList();
                Date startTime = payload.getStartTime();
                Date endTime = payload.getEndTime();
                String[] altTypes = payload.getAltTypeArray();
                String type = payload.getType();
                String domain = payload.getDomain();
                String hostname = payload.getHostname();
                try {
                    alts = altTypes == null ? this.m_alterationDao.findByDtdh(startTime, endTime, type, domain, hostname, AlterationEntity.READSET_FULL) : this.m_alterationDao.findByDtdhTypes(startTime, endTime, type, domain, hostname, altTypes, AlterationEntity.READSET_FULL);
                }
                catch (DalNotFoundException dalNotFoundException) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                model.setAlterationMinuites(this.generateAlterationMinutes(alts));
            }
        }
        model.setAction((org.unidal.web.mvc.Action)action);
        model.setPage((Page)ReportPage.ALTERATION);
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    public boolean isIllegalArgs(Payload payload) {
        if (StringUtils.isEmpty((String)payload.getType())) {
            return true;
        }
        if ("SQL".equals(payload.getType())) {
            boolean ret = this.normalizeArgs(payload);
            if (!ret) {
                return true;
            }
        } else {
            if (StringUtils.isEmpty((String)payload.getTitle())) {
                return true;
            }
            if (StringUtils.isEmpty((String)payload.getDomain())) {
                return true;
            }
            if (StringUtils.isEmpty((String)payload.getHostname())) {
                return true;
            }
            if (payload.getAlterationDate() == null) {
                return true;
            }
            if (StringUtils.isEmpty((String)payload.getUser())) {
                return true;
            }
            if (StringUtils.isEmpty((String)payload.getContent())) {
                return true;
            }
            if ("puppet".equals(payload.getType())) {
                return true;
            }
        }
        return false;
    }

    private boolean normalizeArgs(Payload payload) {
        if (StringUtils.isEmpty((String)payload.getTitle())) {
            return false;
        }
        boolean domainEmpty = StringUtils.isEmpty((String)payload.getDomain());
        boolean hostEmpty = StringUtils.isEmpty((String)payload.getHostname());
        boolean ipEmpty = StringUtils.isEmpty((String)payload.getIp());
        if (ipEmpty && domainEmpty && hostEmpty) {
            return false;
        }
        if (domainEmpty) {
            payload.setDomain(EMPTY);
        }
        if (hostEmpty) {
            payload.setHostname(EMPTY);
        }
        if (ipEmpty) {
            payload.setIp(EMPTY);
        }
        if (payload.getAlterationDate() == null) {
            payload.setAlterationDate(this.m_sdf.format(new Date()));
        }
        if (StringUtils.isEmpty((String)payload.getUser())) {
            payload.setUrl(EMPTY);
        }
        if (StringUtils.isEmpty((String)payload.getUrl())) {
            payload.setUrl(EMPTY);
        }
        return !StringUtils.isEmpty((String)payload.getContent());
    }

    public void setInsertResult(Model model, int status) {
        if (status == 0) {
            model.setInsertResult("{\"status\":200}");
        } else if (status == 1) {
            model.setInsertResult("{\"status\":500}");
        } else if (status == 2) {
            model.setInsertResult("{\"status\":500, \"errorMessage\":\"lack args\"}");
        }
    }
}

