/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.util.StringUtils;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.business.Action;
import com.dianping.cat.report.page.business.Context;
import com.dianping.cat.report.page.business.Handler;
import com.dianping.cat.report.page.business.JspViewer;
import com.dianping.cat.report.page.business.Model;
import com.dianping.cat.report.page.business.Payload;
import com.dianping.cat.report.page.business.Type;
import com.dianping.cat.report.page.business.graph.BusinessGraphCreator;
import com.dianping.cat.service.ProjectService;
import com.dianping.cat.system.page.business.config.BusinessTagConfigManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private BusinessGraphCreator m_graphCreator;
    @Inject
    private BusinessTagConfigManager m_tagConfigManager;

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="business")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="business")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        this.setDomainNameByCookie(ctx);
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        this.normalize(model, payload);
        Date startDate = payload.getStartDate();
        Date endDate = payload.getEndDate();
        model.setStartTime(startDate);
        model.setEndTime(endDate);
        switch (1.$SwitchMap$com$dianping$cat$report$page$business$Action[action.ordinal()]) {
            case 1: {
                Type type = Type.getType((String)payload.getType(), (Type)Type.Domain);
                String name = payload.getName();
                Map allCharts = this.buildLineCharts(type, name, startDate, endDate);
                model.setLineCharts(new ArrayList(allCharts.values()));
                if (type != Type.Domain) break;
                model.setDisplayDomain(name);
            }
        }
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    private void setDomainNameByCookie(Context ctx) {
        try {
            Cookie[] cookies;
            String v = ctx.getHttpServletRequest().getParameter("v");
            if (StringUtils.isNotEmpty((String)v)) {
                return;
            }
            for (Cookie cookie : cookies = ctx.getHttpServletRequest().getCookies()) {
                if (!"app".equals(cookie.getName()) || !StringUtils.isNotEmpty((String)cookie.getValue()) || !StringUtils.isNotEmpty((String)v)) continue;
                ((Payload)ctx.getPayload()).setName(cookie.getValue());
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }

    private Map<String, LineChart> buildLineCharts(Type type, String name, Date start, Date end) {
        Map allCharts = null;
        allCharts = type == Type.Tag ? this.m_graphCreator.buildGraphByTag(start, end, name) : this.m_graphCreator.buildGraphByDomain(start, end, name);
        return allCharts;
    }

    private void normalize(Model model, Payload payload) {
        model.setDomains(this.m_projectService.findAllDomains());
        model.setTags(this.m_tagConfigManager.findAllTags());
        model.setPage((Page)ReportPage.BUSINESS);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
    }
}

