/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business;

import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.business.Action;
import com.dianping.cat.report.page.business.Type;
import com.site.lookup.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.payload.annotation.FieldMeta;

public class Payload
extends AbstractReportPayload<Action, ReportPage> {
    private ReportPage m_page;
    @FieldMeta(value="op")
    private Action m_action;
    @FieldMeta(value="type")
    private String m_type = Type.Domain.getName();
    @FieldMeta(value="name")
    private String m_name;
    @FieldMeta(value="timeRange")
    private int m_timeRange;
    private SimpleDateFormat m_format = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public Payload() {
        super((Page)ReportPage.BUSINESS);
    }

    public Action getAction() {
        return this.m_action;
    }

    public void setAction(String action) {
        this.m_action = Action.getByName((String)action, (Action)Action.VIEW);
    }

    public ReportPage getPage() {
        return this.m_page;
    }

    public void setPage(String page) {
        this.m_page = ReportPage.getByName((String)page, (ReportPage)ReportPage.BUSINESS);
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public Date getStartDate() {
        Date start = null;
        try {
            if (this.m_customStart != null && this.m_customStart.length() > 0) {
                start = this.m_format.parse(this.m_customStart);
                start = this.buildDate(start);
            } else {
                start = new Date(this.getEndDate().getTime() - 3600000L * (long)this.getTimeRange(4));
            }
            return start;
        }
        catch (Exception e) {
            return TimeHelper.getCurrentHour((int)(1 - this.getTimeRange(4)));
        }
    }

    public int getTimeRange(int d) {
        if (this.m_timeRange == 0) {
            return d;
        }
        return this.m_timeRange;
    }

    private Date buildDate(Date date) {
        long time = date.getTime();
        return new Date(time - time % 3600000L + (long)this.m_step * 3600000L);
    }

    public Date getEndDate() {
        Date end = null;
        try {
            end = this.m_customEnd != null && this.m_customEnd.length() > 0 ? this.m_format.parse(this.m_customEnd) : TimeHelper.getCurrentHour((int)1);
            return this.buildDate(end);
        }
        catch (Exception e) {
            return TimeHelper.getCurrentHour((int)1);
        }
    }

    public String getName() {
        if (StringUtils.isEmpty((String)this.m_name)) {
            return "cat";
        }
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public int getTimeRange() {
        return this.m_timeRange;
    }

    public void setTimeRange(int timeRange) {
        this.m_timeRange = timeRange;
    }

    public void validate(ActionContext<?> ctx) {
        if (this.m_action == null) {
            this.m_action = Action.VIEW;
        }
    }
}

