/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.business.BusinessReportMerger;
import com.dianping.cat.consumer.business.model.IVisitor;
import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.consumer.business.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Named;

@Named
public class BusinessReportService
extends AbstractReportService<BusinessReport> {
    public BusinessReport makeReport(String domain, Date start, Date end) {
        BusinessReport report = new BusinessReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public BusinessReport queryDailyReport(String domain, Date start, Date end) {
        throw new UnsupportedOperationException("Business report don't support daily report");
    }

    public BusinessReport queryHourlyReport(String domain, Date start, Date end) {
        BusinessReportMerger merger = new BusinessReportMerger(new BusinessReport(domain));
        long endTime = end.getTime();
        String name = "business";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            Date period = new Date(startTime);
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(period, domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    BusinessReport reportModel = this.queryFromHourlyBinary(report.getId(), period, domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        BusinessReport businessReport = merger.getBusinessReport();
        businessReport.setStartTime(start);
        businessReport.setEndTime(new Date(end.getTime() - 1L));
        return businessReport;
    }

    private BusinessReport queryFromHourlyBinary(int id, Date period, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, period, HourlyReportContentEntity.READSET_CONTENT);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new BusinessReport(domain);
    }

    public BusinessReport queryMonthlyReport(String domain, Date start) {
        throw new UnsupportedOperationException("Business report don't support monthly report");
    }

    public BusinessReport queryWeeklyReport(String domain, Date start) {
        throw new UnsupportedOperationException("Business report don't support weekly report");
    }
}

