/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.business.service;

import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.report.page.business.service.BusinessReportService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.util.Date;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;

public class CachedBusinessReportService {
    private final Map<String, BusinessReport> m_businessReports = new /* Unavailable Anonymous Inner Class!! */;
    @Inject
    private BusinessReportService m_reportService;
    @Inject(type=ModelService.class, value={"business"})
    private ModelService<BusinessReport> m_service;

    public BusinessReport queryBusinessReport(String domain, Date start) {
        long time = start.getTime();
        ModelPeriod period = ModelPeriod.getByTime((long)time);
        if (period == ModelPeriod.CURRENT || period == ModelPeriod.LAST) {
            ModelRequest request = new ModelRequest(domain, time);
            if (this.m_service.isEligable(request)) {
                ModelResponse response = this.m_service.invoke(request);
                BusinessReport report = (BusinessReport)response.getModel();
                return report;
            }
            throw new RuntimeException("Internal error: no eligable business service registered for " + request + "!");
        }
        return this.getReportFromCache(domain, time);
    }

    private BusinessReport getReportFromCache(String domain, long time) {
        String key = domain + time;
        BusinessReport result = (BusinessReport)this.m_businessReports.get(key);
        if (result == null) {
            Date start = new Date(time);
            Date end = new Date(time + 3600000L);
            result = (BusinessReport)this.m_reportService.queryReport(domain, start, end);
            this.m_businessReports.put(key, result);
        }
        return result;
    }
}

