/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cache;

import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.page.cache.CacheReport;
import com.dianping.cat.report.page.cache.Context;
import com.dianping.cat.report.page.cache.Handler;
import com.dianping.cat.report.page.cache.JspViewer;
import com.dianping.cat.report.page.cache.Model;
import com.dianping.cat.report.page.cache.Payload;
import com.dianping.cat.report.page.cache.TransactionReportVistor;
import com.dianping.cat.report.page.event.service.EventReportService;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.page.transaction.transform.AllMachineMerger;
import com.dianping.cat.report.page.transaction.transform.AllNameMerger;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject(type=ModelService.class, value={"event"})
    private ModelService<EventReport> m_eventService;
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private TransactionReportService m_transactionReportService;
    @Inject
    private EventReportService m_eventReportService;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject(type=ModelService.class, value={"transaction"})
    private ModelService<TransactionReport> m_transactionService;

    private CacheReport buildCacheReport(TransactionReport transactionReport, EventReport eventReport, Payload payload) {
        String type = payload.getType();
        String queryName = payload.getQueryName();
        String ip = payload.getIpAddress();
        String sortBy = payload.getSortBy();
        TransactionReportVistor vistor = new TransactionReportVistor();
        vistor.setType(type).setQueryName(queryName).setSortBy(sortBy).setCurrentIp(ip);
        vistor.setEventReport(eventReport);
        vistor.visitTransactionReport(transactionReport);
        return vistor.getCacheReport();
    }

    private String buildPieChart(CacheReport report) {
        PieChart chart = new PieChart();
        ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
        List nameItems = report.getNameItems();
        for (CacheReport.CacheNameItem cacheItem : nameItems) {
            String name = cacheItem.getName().getId();
            if (!name.endsWith(":get") && !name.endsWith(":mGet")) continue;
            items.add(new PieChart.Item().setTitle(name).setNumber((double)cacheItem.getName().getTotalCount()));
        }
        chart.addItems(items);
        return chart.getJsonString();
    }

    private EventReport getHistoryEventReport(Payload payload) {
        com.dianping.cat.report.page.event.transform.AllMachineMerger allEvent;
        String domain = payload.getDomain();
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        EventReport report = (EventReport)this.m_eventReportService.queryReport(domain, start, end);
        if ("All".equalsIgnoreCase(payload.getIpAddress())) {
            allEvent = new com.dianping.cat.report.page.event.transform.AllMachineMerger();
            allEvent.visitEventReport(report);
            report = allEvent.getReport();
        }
        if ("All".equalsIgnoreCase(payload.getType())) {
            allEvent = new com.dianping.cat.report.page.event.transform.AllNameMerger();
            allEvent.visitEventReport(report);
            report = allEvent.getReport();
        }
        return report;
    }

    private TransactionReport getHistoryTransactionReport(Payload payload) {
        AllMachineMerger all;
        String domain = payload.getDomain();
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        TransactionReport report = (TransactionReport)this.m_transactionReportService.queryReport(domain, start, end);
        if ("All".equalsIgnoreCase(payload.getIpAddress())) {
            all = new AllMachineMerger();
            all.visitTransactionReport(report);
            report = all.getReport();
        }
        if ("All".equalsIgnoreCase(payload.getType())) {
            all = new AllNameMerger();
            all.visitTransactionReport(report);
            report = all.getReport();
        }
        return report;
    }

    private EventReport getHourlyEventReport(Payload payload) {
        com.dianping.cat.report.page.event.transform.AllMachineMerger allEvent;
        ModelResponse response;
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        String type = payload.getType();
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("ip", ipAddress);
        EventReport eventReport = null;
        if (StringUtils.isEmpty((String)type)) {
            response = this.m_eventService.invoke(request);
            eventReport = (EventReport)response.getModel();
        } else {
            request.setProperty("type", type);
            response = this.m_eventService.invoke(request);
            eventReport = (EventReport)response.getModel();
        }
        if ("All".equalsIgnoreCase(ipAddress)) {
            allEvent = new com.dianping.cat.report.page.event.transform.AllMachineMerger();
            allEvent.visitEventReport(eventReport);
            eventReport = allEvent.getReport();
        }
        if ("All".equalsIgnoreCase(type)) {
            allEvent = new com.dianping.cat.report.page.event.transform.AllNameMerger();
            allEvent.visitEventReport(eventReport);
            eventReport = allEvent.getReport();
        }
        return eventReport;
    }

    private TransactionReport getHourlyTransactionReport(Payload payload) {
        AllMachineMerger all;
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        String type = payload.getType();
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("ip", ipAddress);
        TransactionReport transactionReport = null;
        if (StringUtils.isNotEmpty((String)type)) {
            request.setProperty("type", type);
        }
        ModelResponse response = this.m_transactionService.invoke(request);
        transactionReport = (TransactionReport)response.getModel();
        if ("All".equalsIgnoreCase(ipAddress)) {
            all = new AllMachineMerger();
            all.visitTransactionReport(transactionReport);
            transactionReport = all.getReport();
        }
        if ("All".equalsIgnoreCase(type)) {
            all = new AllNameMerger();
            all.visitTransactionReport(transactionReport);
            transactionReport = all.getReport();
        }
        return transactionReport;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="cache")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="cache")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        String type = payload.getType();
        TransactionReport transactionReport = null;
        EventReport eventReport = null;
        this.normalize(model, payload);
        switch (1.$SwitchMap$com$dianping$cat$report$page$cache$Action[payload.getAction().ordinal()]) {
            case 1: {
                transactionReport = this.getHourlyTransactionReport(payload);
                eventReport = this.getHourlyEventReport(payload);
                break;
            }
            case 2: {
                transactionReport = this.getHistoryTransactionReport(payload);
                eventReport = this.getHistoryEventReport(payload);
            }
        }
        if (transactionReport != null && eventReport != null) {
            CacheReport cacheReport = this.buildCacheReport(transactionReport, eventReport, payload);
            model.setReport(cacheReport);
            if (!StringUtils.isEmpty((String)type)) {
                model.setPieChart(this.buildPieChart(model.getReport()));
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        model.setAction((Action)payload.getAction());
        model.setPage((Page)ReportPage.CACHE);
        model.setQueryName(payload.getQueryName());
    }
}

