/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross.display;

import com.dianping.cat.consumer.cross.model.entity.Local;
import com.dianping.cat.consumer.cross.model.entity.Name;
import com.dianping.cat.consumer.cross.model.entity.Remote;
import com.dianping.cat.consumer.cross.model.entity.Type;
import com.dianping.cat.consumer.cross.model.transform.BaseVisitor;
import com.dianping.cat.report.page.cross.display.NameComparator;
import com.dianping.cat.report.page.cross.display.NameDetailInfo;
import com.dianping.cat.service.HostinfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MethodInfo
extends BaseVisitor {
    private static final String ALL_METHOD = "AllMethods";
    private Map<String, NameDetailInfo> m_callProjectsInfo = new LinkedHashMap();
    private Map<String, NameDetailInfo> m_serviceProjectsInfo = new LinkedHashMap();
    private Map<String, NameDetailInfo> m_callerProjectsInfo = new LinkedHashMap();
    private String m_remoteProject;
    private String m_clientIp;
    private String m_currentType;
    private String m_currentRole;
    private String m_remoteIp;
    private long m_reportDuration;
    private String m_query;
    private String m_callSortBy = "Avg";
    private String m_serviceSortBy = "Avg";
    private HostinfoService m_hostinfoService;

    public MethodInfo(long reportDuration) {
        this.m_reportDuration = reportDuration;
    }

    private void addCallerProject(String type, Name name) {
        NameDetailInfo info;
        String id = name.getId();
        NameDetailInfo all = (NameDetailInfo)this.m_callerProjectsInfo.get(ALL_METHOD);
        if (all == null) {
            all = new NameDetailInfo(this.m_reportDuration, ALL_METHOD, this.m_remoteIp, type);
            this.m_callerProjectsInfo.put(ALL_METHOD, all);
        }
        if ((info = (NameDetailInfo)this.m_callerProjectsInfo.get(id)) == null) {
            info = new NameDetailInfo(this.m_reportDuration, name.getId(), this.m_remoteIp, type);
            this.m_callerProjectsInfo.put(id, info);
        }
        info.mergeName(name);
        all.mergeName(name);
    }

    private void addCallProject(String type, Name name) {
        NameDetailInfo info;
        String id = name.getId();
        NameDetailInfo all = (NameDetailInfo)this.m_callProjectsInfo.get(ALL_METHOD);
        if (all == null) {
            all = new NameDetailInfo(this.m_reportDuration, ALL_METHOD, this.m_remoteIp, type);
            this.m_callProjectsInfo.put(ALL_METHOD, all);
        }
        if ((info = (NameDetailInfo)this.m_callProjectsInfo.get(id)) == null) {
            info = new NameDetailInfo(this.m_reportDuration, name.getId(), this.m_remoteIp, type);
            this.m_callProjectsInfo.put(id, info);
        }
        info.mergeName(name);
        all.mergeName(name);
    }

    private void addServiceProject(String type, Name name) {
        NameDetailInfo info;
        String id = name.getId();
        NameDetailInfo all = (NameDetailInfo)this.m_serviceProjectsInfo.get(ALL_METHOD);
        if (all == null) {
            all = new NameDetailInfo(this.m_reportDuration, ALL_METHOD, this.m_remoteIp, type);
            this.m_serviceProjectsInfo.put(ALL_METHOD, all);
        }
        if ((info = (NameDetailInfo)this.m_serviceProjectsInfo.get(id)) == null) {
            info = new NameDetailInfo(this.m_reportDuration, name.getId(), this.m_remoteIp, type);
            this.m_serviceProjectsInfo.put(id, info);
        }
        info.mergeName(name);
        all.mergeName(name);
    }

    public Map<String, NameDetailInfo> getCallerProjectsInfo() {
        return this.m_callerProjectsInfo;
    }

    public Collection<NameDetailInfo> getCallProjectsInfo() {
        ArrayList<NameDetailInfo> values = new ArrayList<NameDetailInfo>(this.m_callProjectsInfo.values());
        Collections.sort(values, new NameComparator(this.m_callSortBy));
        return values;
    }

    public String getQuery() {
        return this.m_query;
    }

    public MethodInfo setQuery(String query) {
        this.m_query = query;
        return this;
    }

    public long getReportDuration() {
        return this.m_reportDuration;
    }

    public List<NameDetailInfo> getServiceProjectsInfo() {
        ArrayList<NameDetailInfo> values = new ArrayList<NameDetailInfo>(this.m_serviceProjectsInfo.values());
        Collections.sort(values, new NameComparator(this.m_serviceSortBy));
        return values;
    }

    private boolean isFit(String queryName, String methodName) {
        String[] args = queryName.split("\\|");
        if (args != null) {
            for (String str : args) {
                if (str.length() <= 0 || !methodName.toLowerCase().contains(str.trim().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean projectContains(String projectName, String app, String ip, String role) {
        if (this.m_remoteIp.startsWith("All")) {
            if (this.m_remoteProject.startsWith("AllClient") && (role.endsWith("Client") || role.endsWith("Caller"))) {
                return true;
            }
            if (this.m_remoteProject.startsWith("AllServer") && role.endsWith("Server")) {
                return true;
            }
            if (StringUtils.isNotEmpty((String)app)) {
                if (app.equalsIgnoreCase(projectName)) {
                    return true;
                }
            } else {
                String domain;
                if (ip.indexOf(58) > 0) {
                    ip = ip.substring(0, ip.indexOf(58));
                }
                if (projectName.equalsIgnoreCase(domain = this.m_hostinfoService.queryDomainByIp(ip))) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public MethodInfo setCallSortBy(String callSoryBy) {
        this.m_callSortBy = callSoryBy;
        return this;
    }

    public MethodInfo setClientIp(String clientIp) {
        this.m_clientIp = clientIp;
        return this;
    }

    public void setHostinfoService(HostinfoService hostinfoService) {
        this.m_hostinfoService = hostinfoService;
    }

    public MethodInfo setRemoteIp(String remoteIp) {
        this.m_remoteIp = remoteIp;
        return this;
    }

    public void setRemoteProject(String remoteProject) {
        this.m_remoteProject = remoteProject;
    }

    public MethodInfo setServiceSortBy(String serviceSortBy) {
        this.m_serviceSortBy = serviceSortBy;
        return this;
    }

    public void visitLocal(Local local) {
        if (this.m_clientIp.equalsIgnoreCase("All") || this.m_clientIp.equalsIgnoreCase(local.getId())) {
            super.visitLocal(local);
        }
    }

    public void visitName(Name name) {
        String role = this.m_currentRole;
        if (StringUtils.isEmpty((String)this.m_query) || this.isFit(this.m_query, name.getId())) {
            if (role != null && role.endsWith("Client")) {
                this.addServiceProject(this.m_currentType, name);
            } else if (role != null && role.endsWith("Server")) {
                this.addCallProject(this.m_currentType, name);
            } else if (role != null && role.endsWith("Caller")) {
                this.addCallerProject(this.m_currentType, name);
            }
        }
    }

    public void visitRemote(Remote remote) {
        String app;
        String role = remote.getRole();
        String ip = remote.getIp();
        if (ip == null && (ip = remote.getId()).endsWith(":Caller") && role.endsWith("Caller")) {
            ip = ip.substring(0, ip.indexOf(":Caller"));
        }
        if (this.projectContains(this.m_remoteProject, app = remote.getApp(), ip, role) || this.m_remoteIp.equals(ip)) {
            this.m_currentRole = role;
            super.visitRemote(remote);
        }
    }

    public void visitType(Type type) {
        this.m_currentType = type.getId();
        super.visitType(type);
    }
}

