/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.cross.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.cross.CrossReportMerger;
import com.dianping.cat.consumer.cross.model.IVisitor;
import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.consumer.cross.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentEntity;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentEntity;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Named;

@Named
public class CrossReportService
extends AbstractReportService<CrossReport> {
    public CrossReport makeReport(String domain, Date start, Date end) {
        CrossReport report = new CrossReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public CrossReport queryDailyReport(String domain, Date start, Date end) {
        CrossReportMerger merger = new CrossReportMerger(new CrossReport(domain));
        long endTime = end.getTime();
        String name = "cross";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, new Date(startTime), DailyReportEntity.READSET_FULL);
                CrossReport reportModel = this.queryFromDailyBinary(report.getId(), domain);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (DalNotFoundException report) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        CrossReport crossReport = merger.getCrossReport();
        crossReport.setStartTime(start);
        crossReport.setEndTime(end);
        return crossReport;
    }

    private CrossReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new CrossReport(domain);
    }

    private CrossReport queryFromHourlyBinary(int id, Date period, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, period, HourlyReportContentEntity.READSET_CONTENT);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new CrossReport(domain);
    }

    private CrossReport queryFromMonthlyBinary(int id, String domain) throws DalException {
        MonthlyReportContent content = this.m_monthlyReportContentDao.findByPK(id, MonthlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new CrossReport(domain);
    }

    private CrossReport queryFromWeeklyBinary(int id, String domain) throws DalException {
        WeeklyReportContent content = this.m_weeklyReportContentDao.findByPK(id, WeeklyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new CrossReport(domain);
    }

    public CrossReport queryHourlyReport(String domain, Date start, Date end) {
        CrossReportMerger merger = new CrossReportMerger(new CrossReport(domain));
        long endTime = end.getTime();
        String name = "cross";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    CrossReport reportModel = this.queryFromHourlyBinary(report.getId(), report.getPeriod(), domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        CrossReport crossReport = merger.getCrossReport();
        crossReport.setStartTime(start);
        crossReport.setEndTime(new Date(end.getTime() - 1L));
        return crossReport;
    }

    public CrossReport queryMonthlyReport(String domain, Date start) {
        try {
            MonthlyReport entity = this.m_monthlyReportDao.findReportByDomainNamePeriod(start, domain, "cross", MonthlyReportEntity.READSET_FULL);
            return this.queryFromMonthlyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new CrossReport(domain);
    }

    public CrossReport queryWeeklyReport(String domain, Date start) {
        try {
            WeeklyReport entity = this.m_weeklyReportDao.findReportByDomainNamePeriod(start, domain, "cross", WeeklyReportEntity.READSET_FULL);
            return this.queryFromWeeklyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new CrossReport(domain);
    }
}

