/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.graph;

import com.dianping.cat.consumer.dependency.model.entity.Dependency;
import com.dianping.cat.consumer.dependency.model.entity.Index;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import com.dianping.cat.report.page.dependency.graph.GraphConstrant;
import com.dianping.cat.report.page.dependency.graph.TopologyGraphConfigManager;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.tuple.Pair;

@Named
public class DependencyItemBuilder {
    private static final int OK = GraphConstrant.OK;
    private static final String DATABASE = "database";
    private static final String PROJECT = "project";
    private static final String CACHE = "cache";
    @Inject
    private TopologyGraphConfigManager m_graphConfigManager;

    public TopologyEdge buildEdge(String domain, Dependency dependency) {
        TopologyEdge edge = new TopologyEdge();
        edge.setType(dependency.getType());
        edge.setKey(dependency.getType() + ':' + domain + ':' + dependency.getTarget());
        edge.setSelf(domain);
        edge.setTarget(dependency.getTarget());
        edge.setOpposite(false);
        edge.setWeight(1);
        Pair state = this.m_graphConfigManager.buildEdgeState(domain, dependency);
        edge.setStatus(((Integer)state.getKey()).intValue());
        edge.setDes((String)state.getValue());
        return edge;
    }

    public TopologyNode buildNode(String domain, Index index) {
        TopologyNode node = new TopologyNode(domain);
        node.setType(PROJECT);
        node.setWeight(1);
        Pair state = this.m_graphConfigManager.buildNodeState(domain, index);
        node.setStatus(((Integer)state.getKey()).intValue());
        node.setDes((String)state.getValue());
        return node;
    }

    public TopologyNode createCacheNode(String cache) {
        TopologyNode node = new TopologyNode(cache);
        node.setStatus(OK);
        node.setType(CACHE);
        node.setWeight(1);
        return node;
    }

    public TopologyNode createDatabaseNode(String database) {
        TopologyNode node = new TopologyNode(database);
        node.setStatus(OK);
        node.setType(DATABASE);
        node.setWeight(1);
        return node;
    }

    public TopologyNode createNode(String domain) {
        TopologyNode node = new TopologyNode(domain);
        node.setStatus(OK);
        node.setType(PROJECT);
        node.setWeight(1);
        return node;
    }
}

