/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.graph;

import com.dianping.cat.consumer.dependency.model.entity.Dependency;
import com.dianping.cat.consumer.dependency.model.entity.DependencyReport;
import com.dianping.cat.consumer.dependency.model.entity.Index;
import com.dianping.cat.consumer.dependency.model.entity.Segment;
import com.dianping.cat.consumer.dependency.model.transform.BaseVisitor;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.dependency.graph.LineGraphBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * Exception performing whole class analysis ignored.
 */
public class LineGraphBuilder
extends BaseVisitor {
    private static final String TOTAL_COUNT = "TotalCount";
    private static final String ERROR_COUNT = "ErrorCount";
    private static final String AVG = "Avg";
    private static int SIZE = 60;
    public Map<String, Map<String, Item>> m_dependencies = new HashMap();
    private Set<String> m_types = new TreeSet();
    private long m_period;
    private int m_currentMinute;
    private long m_sysMinute;
    private Date m_start;

    public LineGraphBuilder() {
        long current = System.currentTimeMillis();
        current -= current % 3600000L;
        this.m_period = current;
        this.m_sysMinute = System.currentTimeMillis() / 1000L / 60L % 60L;
    }

    private boolean isCurrentPeriod() {
        return this.m_period == this.m_start.getTime();
    }

    private String appendStr(String ... arg) {
        int length = arg.length;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(arg[i]).append(" ");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    private LineChart buildLineChart(String title, Map<String, Item> items) {
        LineChart result = new LineChart();
        result.setSize(SIZE);
        result.setStep(60000L);
        result.setTitle(title);
        result.setStart(this.m_start);
        if (items != null) {
            for (Map.Entry<String, Item> entry : items.entrySet()) {
                String subTitle = entry.getKey();
                Item item = entry.getValue();
                result.add(subTitle, item.getValue());
            }
        }
        return result;
    }

    private Item generateItem() {
        Item result = new Item(this);
        long size = (int)this.m_sysMinute + 1;
        if (!this.isCurrentPeriod()) {
            size = SIZE;
        }
        int i = 0;
        while ((long)i < size) {
            Item.access$000((Item)result, (int)i, (double)0.0);
            ++i;
        }
        return result;
    }

    public Item findOrCreateItem(String type, String id) {
        Item result;
        HashMap<String, Item> items = (HashMap<String, Item>)this.m_dependencies.get(type);
        if (items == null) {
            items = new HashMap<String, Item>();
            this.m_dependencies.put(type, items);
        }
        if ((result = (Item)items.get(id)) == null) {
            result = this.generateItem();
            items.put(id, result);
        }
        return result;
    }

    public Map<String, List<LineChart>> queryDependencyGraph() {
        HashMap<String, List<LineChart>> allCharts = new HashMap<String, List<LineChart>>();
        for (String type : this.m_types) {
            ArrayList<LineChart> charts = new ArrayList<LineChart>();
            Map totalItems = (Map)this.m_dependencies.get(this.appendStr(new String[]{type, "TotalCount"}));
            Map errorItems = (Map)this.m_dependencies.get(this.appendStr(new String[]{type, "ErrorCount"}));
            Map avgItems = (Map)this.m_dependencies.get(this.appendStr(new String[]{type, "Avg"}));
            charts.add(this.buildLineChart("TotalCount", totalItems));
            charts.add(this.buildLineChart("ErrorCount", errorItems));
            charts.add(this.buildLineChart("Avg", avgItems));
            allCharts.put(type, charts);
        }
        return allCharts;
    }

    public List<LineChart> queryIndex() {
        ArrayList<LineChart> charts = new ArrayList<LineChart>();
        charts.add(this.buildLineChart("TotalCount", (Map)this.m_dependencies.get("TotalCount")));
        charts.add(this.buildLineChart("ErrorCount", (Map)this.m_dependencies.get("ErrorCount")));
        charts.add(this.buildLineChart("Avg", (Map)this.m_dependencies.get("Avg")));
        return charts;
    }

    public void visitDependency(Dependency dependency) {
        String type = dependency.getType();
        String target = dependency.getTarget();
        long count = dependency.getTotalCount();
        long error = dependency.getErrorCount();
        double avg = dependency.getAvg();
        this.m_types.add(type);
        Item.access$000((Item)this.findOrCreateItem(this.appendStr(new String[]{type, "TotalCount"}), target), (int)this.m_currentMinute, (double)count);
        Item.access$000((Item)this.findOrCreateItem(this.appendStr(new String[]{type, "ErrorCount"}), target), (int)this.m_currentMinute, (double)error);
        Item.access$000((Item)this.findOrCreateItem(this.appendStr(new String[]{type, "Avg"}), target), (int)this.m_currentMinute, (double)avg);
        super.visitDependency(dependency);
    }

    public void visitDependencyReport(DependencyReport dependencyReport) {
        this.m_start = dependencyReport.getStartTime();
        super.visitDependencyReport(dependencyReport);
    }

    public void visitIndex(Index index) {
        String id = index.getName();
        long count = index.getTotalCount();
        long error = index.getErrorCount();
        double avg = index.getAvg();
        Item.access$000((Item)this.findOrCreateItem("TotalCount", id), (int)this.m_currentMinute, (double)count);
        Item.access$000((Item)this.findOrCreateItem("ErrorCount", id), (int)this.m_currentMinute, (double)error);
        Item.access$000((Item)this.findOrCreateItem("Avg", id), (int)this.m_currentMinute, (double)avg);
        super.visitIndex(index);
    }

    public void visitSegment(Segment segment) {
        this.m_currentMinute = segment.getId();
        super.visitSegment(segment);
    }
}

