/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.dependency.graph;

import com.dianping.cat.consumer.dependency.model.entity.Dependency;
import com.dianping.cat.consumer.dependency.model.entity.DependencyReport;
import com.dianping.cat.consumer.dependency.model.entity.Index;
import com.dianping.cat.consumer.dependency.model.entity.Segment;
import com.dianping.cat.consumer.dependency.model.transform.BaseVisitor;
import com.dianping.cat.home.dependency.graph.entity.TopologyEdge;
import com.dianping.cat.home.dependency.graph.entity.TopologyGraph;
import com.dianping.cat.home.dependency.graph.entity.TopologyNode;
import com.dianping.cat.report.page.dependency.graph.DependencyItemBuilder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.util.StringUtils;

@Named
public class TopologyGraphBuilder
extends BaseVisitor {
    @Inject
    private DependencyItemBuilder m_itemBuilder;
    private String m_domain;
    private Map<Long, TopologyGraph> m_graphs = new HashMap();
    private int m_minute;
    private Date m_date;
    private Set<String> m_pigeonServices = new HashSet<String>(Arrays.asList("Service", "PigeonService", "PigeonServer"));

    public TopologyEdge cloneEdge(TopologyEdge edge) {
        TopologyEdge result = new TopologyEdge();
        result.setDes(edge.getDes());
        result.setKey(edge.getKey());
        result.setLink(edge.getLink());
        result.setOpposite(edge.getOpposite());
        result.setSelf(edge.getSelf());
        result.setStatus(edge.getStatus());
        result.setTarget(edge.getTarget());
        result.setType(edge.getType());
        result.setWeight(edge.getWeight());
        return result;
    }

    public TopologyNode cloneNode(TopologyNode node) {
        TopologyNode result = new TopologyNode();
        result.setDes(node.getDes());
        result.setId(node.getId());
        result.setLink(node.getLink());
        result.setStatus(node.getStatus());
        result.setType(node.getType());
        result.setWeight(node.getWeight());
        return result;
    }

    public TopologyNode createNode(String domain) {
        return this.m_itemBuilder.createNode(domain);
    }

    private TopologyGraph findOrCreateGraph() {
        long time = this.m_date.getTime() + (long)this.m_minute * 60000L;
        TopologyGraph graph = (TopologyGraph)this.m_graphs.get(time);
        if (graph == null) {
            graph = new TopologyGraph();
            this.m_graphs.put(time, graph);
        }
        return graph;
    }

    public Map<Long, TopologyGraph> getGraphs() {
        return this.m_graphs;
    }

    public String mergeDes(String old, String des) {
        if (StringUtils.isEmpty((String)old)) {
            return des;
        }
        if (StringUtils.isEmpty((String)des)) {
            return old;
        }
        return old + des;
    }

    private TopologyEdge mergeEdge(TopologyEdge old, TopologyEdge edge) {
        if (old == null) {
            return edge;
        }
        if (edge.getStatus() > old.getStatus()) {
            old.setStatus(edge.getStatus());
        }
        if (edge.getWeight() > old.getWeight()) {
            old.setWeight(edge.getWeight());
        }
        old.setDes(this.mergeDes(old.getDes(), edge.getDes()));
        return old;
    }

    private TopologyNode mergeNode(TopologyNode old, TopologyNode node) {
        if (old == null) {
            return node;
        }
        if (node.getStatus() > old.getStatus()) {
            old.setStatus(node.getStatus());
        }
        if (node.getWeight() > old.getWeight()) {
            old.setWeight(node.getWeight());
        }
        old.setDes(this.mergeDes(old.getDes(), node.getDes()));
        return old;
    }

    public void visitDependency(Dependency dependency) {
        String type = dependency.getType();
        if (!this.m_pigeonServices.contains(type)) {
            TopologyEdge edge = this.m_itemBuilder.buildEdge(this.m_domain, dependency);
            TopologyGraph graph = this.findOrCreateGraph();
            TopologyEdge old = graph.findTopologyEdge(edge.getKey());
            graph.getEdges().put(edge.getKey(), this.mergeEdge(old, edge));
            if ("Database".equals(type)) {
                String target = dependency.getTarget();
                TopologyNode nodeOld = graph.findTopologyNode(target);
                graph.getNodes().put(target, this.mergeNode(nodeOld, this.m_itemBuilder.createDatabaseNode(target)));
            } else if ("Cache".equals(type)) {
                String target = dependency.getTarget();
                TopologyNode nodeOld = graph.findTopologyNode(target);
                graph.getNodes().put(target, this.mergeNode(nodeOld, this.m_itemBuilder.createCacheNode(target)));
            }
        }
    }

    public void visitDependencyReport(DependencyReport dependencyReport) {
        this.m_date = dependencyReport.getStartTime();
        this.m_domain = dependencyReport.getDomain();
        super.visitDependencyReport(dependencyReport);
    }

    public void visitIndex(Index index) {
        TopologyGraph graph = this.findOrCreateGraph();
        TopologyNode node = this.m_itemBuilder.buildNode(this.m_domain, index);
        TopologyNode old = graph.findTopologyNode(node.getId());
        graph.getNodes().put(node.getId(), this.mergeNode(old, node));
    }

    public void visitSegment(Segment segment) {
        this.m_minute = segment.getId();
        super.visitSegment(segment);
    }

    public TopologyGraphBuilder setItemBuilder(DependencyItemBuilder itemBuilder) {
        this.m_itemBuilder = itemBuilder;
        return this;
    }
}

