/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.event.task;

import com.dianping.cat.Cat;
import com.dianping.cat.config.AtomicMessageConfigManager;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.event.EventReportCountFilter;
import com.dianping.cat.consumer.event.model.IVisitor;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.page.event.service.EventReportService;
import com.dianping.cat.report.page.event.task.EventReportDailyGraphCreator;
import com.dianping.cat.report.page.event.task.EventReportHourlyGraphCreator;
import com.dianping.cat.report.page.event.task.HistoryEventReportMerger;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import com.dianping.cat.report.task.current.CurrentWeeklyMonthlyReportTask;
import java.util.Date;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="event")
public class EventReportBuilder
implements TaskBuilder,
Initializable {
    public static final String ID = "event";
    @Inject
    protected EventReportService m_reportService;
    @Inject
    protected ServerConfigManager m_serverConfigManager;
    @Inject
    private AtomicMessageConfigManager m_atomicMessageConfigManager;

    public boolean buildDailyTask(String name, String domain, Date period) {
        try {
            EventReport eventReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(domain);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((EventReport)eventReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("event report don't support HourlyReport!");
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentMonth()) ? TimeHelper.getCurrentDay() : TaskHelper.nextMonthStart((Date)period);
        EventReport eventReport = this.queryDailyReportsByDuration(domain, period, end);
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((EventReport)eventReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentWeek()) ? TimeHelper.getCurrentDay() : new Date(period.getTime() + 604800000L);
        EventReport eventReport = this.queryDailyReportsByDuration(domain, period, end);
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((EventReport)eventReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    public void initialize() throws InitializationException {
        CurrentWeeklyMonthlyReportTask.getInstance().register((CurrentWeeklyMonthlyReportTask.CurrentWeeklyMonthlyTask)new /* Unavailable Anonymous Inner Class!! */);
    }

    private EventReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long startTime;
        long endTime = end.getTime();
        double duration = (double)(endTime - startTime) * 1.0 / 8.64E7;
        HistoryEventReportMerger merger = new HistoryEventReportMerger(new EventReport(domain)).setDuration(duration);
        EventReport eventReport = merger.getEventReport();
        EventReportDailyGraphCreator creator = new EventReportDailyGraphCreator(eventReport, (int)duration, start);
        for (startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                EventReport reportModel = (EventReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                creator.createGraph(reportModel);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        eventReport.setStartTime(start);
        eventReport.setEndTime(end);
        new EventReportCountFilter(this.m_serverConfigManager.getMaxTypeThreshold(), this.m_atomicMessageConfigManager.getMaxNameThreshold(domain), this.m_serverConfigManager.getTypeNameLengthLimit()).visitEventReport(eventReport);
        return eventReport;
    }

    private EventReport queryHourlyReportsByDuration(String name, String domain, Date start, Date endDate) throws DalException {
        long startTime;
        long endTime = endDate.getTime();
        double duration = (double)(endTime - startTime) * 1.0 / 8.64E7;
        HistoryEventReportMerger merger = new HistoryEventReportMerger(new EventReport(domain)).setDuration(duration);
        EventReportHourlyGraphCreator graphCreator = new EventReportHourlyGraphCreator(merger.getEventReport(), 10);
        for (startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            EventReport report = (EventReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 3600000L));
            graphCreator.createGraph(report);
            report.accept((IVisitor)merger);
        }
        EventReport dailyReport = merger.getEventReport();
        Date date = dailyReport.getStartTime();
        Date end = new Date(TaskHelper.tomorrowZero((Date)date).getTime() - 1000L);
        dailyReport.setStartTime(TaskHelper.todayZero((Date)date));
        dailyReport.setEndTime(end);
        new EventReportCountFilter(this.m_serverConfigManager.getMaxTypeThreshold(), this.m_atomicMessageConfigManager.getMaxNameThreshold(domain), this.m_serverConfigManager.getTypeNameLengthLimit()).visitEventReport(dailyReport);
        return dailyReport;
    }
}

