/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.event.transform;

import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.report.graph.LineChart;
import com.dianping.cat.report.page.event.Model;
import com.dianping.cat.report.page.event.Payload;
import com.dianping.cat.report.page.event.transform.EventTrendGraphBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventTrendGraphBuilder {
    public static final String COUNT = "count";
    public static final String FAIL = "fail";
    private int m_duration = 1;

    private LineChart buildLineChart(Date start, Date end, long step, int size) {
        LineChart item = new LineChart();
        item.setStart(start);
        item.setSize(size);
        item.setStep(step);
        item.setSubTitles(this.buildSubTitles(start, end));
        return item;
    }

    private String buildSubTitle(Date start, Date end) {
        SimpleDateFormat from = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat to = new SimpleDateFormat("MM-dd");
        StringBuilder sb = new StringBuilder();
        sb.append(from.format(start)).append("~").append(to.format(end));
        return sb.toString();
    }

    private List<String> buildSubTitles(Date start, Date end) {
        ArrayList<String> subTitles = new ArrayList<String>();
        subTitles.add(this.buildSubTitle(start, end));
        return subTitles;
    }

    public void buildTrendGraph(Model model, Payload payload, EventReport report) {
        String name = payload.getName();
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        String reportType = payload.getReportType();
        String ip = payload.getIpAddress();
        String type = payload.getType();
        String display = name != null ? name : type;
        Map data = this.getDatas(report, ip, type, name);
        ReportType queryType = ReportType.findByName((String)reportType);
        long step = queryType.getStep() * (long)this.m_duration;
        int size = (int)((start.getTime() - end.getTime()) / step);
        LineChart fail = this.buildLineChart(start, end, step, size);
        LineChart count = this.buildLineChart(start, end, step, size);
        fail.setTitle(display + queryType.getFailTitle());
        count.setTitle(display + queryType.getSumTitle());
        fail.addValue((double[])data.get("fail"));
        count.addValue((double[])data.get("count"));
        model.setFailureTrend(fail.getJsonString());
        model.setHitTrend(count.getJsonString());
    }

    private Map<String, double[]> getDatas(EventReport report, String ip, String type, String name) {
        EventReportVisitor visitor = new EventReportVisitor(this, ip, type, name);
        visitor.visitEventReport(report);
        return visitor.getDatas();
    }

    static /* synthetic */ int access$102(EventTrendGraphBuilder x0, int x1) {
        x0.m_duration = x1;
        return x0.m_duration;
    }
}

