/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.heartbeat;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.heartbeat.model.entity.HeartbeatReport;
import com.dianping.cat.consumer.heartbeat.model.entity.Machine;
import com.dianping.cat.consumer.heartbeat.model.entity.Period;
import com.dianping.cat.helper.SortHelper;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.svg.GraphBuilder;
import com.dianping.cat.report.page.heartbeat.Context;
import com.dianping.cat.report.page.heartbeat.Handler;
import com.dianping.cat.report.page.heartbeat.HeartbeatSvgGraph;
import com.dianping.cat.report.page.heartbeat.HistoryGraphs;
import com.dianping.cat.report.page.heartbeat.JspViewer;
import com.dianping.cat.report.page.heartbeat.Model;
import com.dianping.cat.report.page.heartbeat.Payload;
import com.dianping.cat.report.page.heartbeat.config.HeartbeatDisplayPolicyManager;
import com.dianping.cat.report.page.heartbeat.service.HeartbeatReportService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private GraphBuilder m_builder;
    @Inject
    private HistoryGraphs m_historyGraphs;
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private HeartbeatReportService m_reportService;
    @Inject(type=ModelService.class, value={"heartbeat"})
    private ModelService<HeartbeatReport> m_service;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private HeartbeatDisplayPolicyManager m_manager;

    private void buildHeartbeatGraphInfo(Model model, HeartbeatSvgGraph displayHeartbeat) {
        if (displayHeartbeat == null) {
            return;
        }
        model.setResult(displayHeartbeat);
        model.setExtensionGraph(displayHeartbeat.getExtensionGraph());
    }

    private void buildHistoryGraph(Model model, Payload payload) {
        Date start = new Date(payload.getDate() + 82800000L);
        Date end = new Date(payload.getDate() + 86400000L);
        HeartbeatReport report = (HeartbeatReport)this.m_reportService.queryReport(payload.getDomain(), start, end);
        List extensionGroups = this.m_manager.sortGroupNames(this.extractExtensionGroups(report));
        model.setExtensionGroups(extensionGroups);
        model.setReport(report);
        if (StringUtils.isEmpty((String)payload.getIpAddress()) || "All".equals(payload.getIpAddress())) {
            String ipAddress = this.getIpAddress(report, payload);
            payload.setIpAddress(ipAddress);
            payload.setRealIp(ipAddress);
        }
        this.m_historyGraphs.showHeartBeatGraph(model, payload);
    }

    private Set<String> extractExtensionGroups(HeartbeatReport report) {
        HashSet<String> groupNames = new HashSet<String>();
        for (Machine machine : report.getMachines().values()) {
            for (Period period : machine.getPeriods()) {
                Set tmpGroupNames = period.getExtensions().keySet();
                groupNames.addAll(tmpGroupNames);
            }
        }
        return groupNames;
    }

    private String getIpAddress(HeartbeatReport report, Payload payload) {
        Set ips = report.getIps();
        String ip = payload.getRealIp();
        if (!(ip != null && ip.length() != 0 || ips.isEmpty())) {
            ip = (String)SortHelper.sortIpAddress((Collection)ips).get(0);
        }
        return ip;
    }

    private HeartbeatReport getReport(String domain, String ipAddress, long date, ModelPeriod period) {
        ModelRequest request = new ModelRequest(domain, date).setProperty("ip", ipAddress);
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            HeartbeatReport report = (HeartbeatReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligable ip service registered for " + request + "!");
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="h")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="h")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        HeartbeatSvgGraph heartbeat = null;
        this.normalize(model, payload);
        switch (1.$SwitchMap$com$dianping$cat$report$page$heartbeat$Action[payload.getAction().ordinal()]) {
            case 1: {
                heartbeat = this.showReport(model, payload);
                this.buildHeartbeatGraphInfo(model, heartbeat);
                break;
            }
            case 2: {
                this.buildHistoryGraph(model, payload);
                break;
            }
            case 3: {
                this.buildHistoryGraph(model, payload);
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        String queryType;
        String ipAddress = payload.getIpAddress();
        model.setAction((Action)payload.getAction());
        model.setPage((Page)ReportPage.HEARTBEAT);
        if (StringUtils.isEmpty((String)ipAddress) || ipAddress.equals("All")) {
            model.setIpAddress("All");
        } else {
            payload.setRealIp(payload.getIpAddress());
            model.setIpAddress(payload.getRealIp());
        }
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        String reportType = payload.getReportType();
        if ("month".equals(reportType) || "week".equals(reportType)) {
            payload.setReportType("day");
        }
        if ((queryType = payload.getType()) == null || queryType.trim().length() == 0) {
            payload.setType("frameworkThread");
        }
    }

    private HeartbeatSvgGraph showReport(Model model, Payload payload) {
        try {
            HeartbeatReport report = this.getReport(payload.getDomain(), payload.getIpAddress(), payload.getDate(), payload.getPeriod());
            model.setReport(report);
            if (report != null) {
                String displayIp = this.getIpAddress(report, payload);
                payload.setRealIp(displayIp);
                return new HeartbeatSvgGraph(this.m_builder, this.m_manager).display(report, displayIp);
            }
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
            model.setException(e);
        }
        return null;
    }
}

