/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.logview;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.logview.Context;
import com.dianping.cat.report.page.logview.Handler;
import com.dianping.cat.report.page.logview.JspViewer;
import com.dianping.cat.report.page.logview.Model;
import com.dianping.cat.report.page.logview.Payload;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private JspViewer m_jspViewer;
    @Inject(type=ModelService.class, value={"logview"})
    private ModelService<String> m_service;
    @Inject
    private ServerConfigManager m_configManager;

    private boolean checkStorageTime(MessageId msg) {
        long current;
        long time = msg.getTimestamp();
        return time > (current = TimeHelper.getCurrentDay().getTime()) - 86400000L * (long)this.m_configManager.getHdfsMaxStorageTime();
    }

    private String getLogView(String messageId, boolean waterfall) {
        try {
            if (messageId != null) {
                MessageId id = MessageId.parse((String)messageId);
                long timestamp = id.getTimestamp();
                ModelRequest request = new ModelRequest(id.getDomain(), timestamp).setProperty("messageId", messageId).setProperty("waterfall", String.valueOf(waterfall)).setProperty("timestamp", String.valueOf(timestamp));
                if (this.m_service.isEligable(request)) {
                    ModelResponse response = this.m_service.invoke(request);
                    String logview = (String)response.getModel();
                    return logview;
                }
                throw new RuntimeException("Internal error: no eligible logview service registered for " + request + "!");
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return null;
        }
        return null;
    }

    private String getMessageId(Payload payload) {
        String[] path = payload.getPath();
        if (path != null && path.length > 0) {
            return path[0];
        }
        return null;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="m")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="m")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        model.setAction((Action)payload.getAction());
        model.setPage((Page)ReportPage.LOGVIEW);
        model.setDomain(payload.getDomain());
        model.setDate(payload.getDate());
        String messageId = this.getMessageId(payload);
        String logView = null;
        MessageId msgId = MessageId.parse((String)messageId);
        if (this.checkStorageTime(msgId)) {
            logView = this.getLogView(messageId, payload.isWaterfall());
            if (logView == null || logView.length() == 0) {
                Cat.logEvent((String)"Logview", (String)(msgId.getDomain() + ":Fail"), (String)"0", (String)messageId);
            } else {
                logView = this.repliceLogview(logView);
                Cat.logEvent((String)"Logview", (String)"Success", (String)"0", (String)messageId);
            }
        } else {
            Cat.logEvent((String)"Logview", (String)"OldMessage", (String)"0", (String)messageId);
        }
        switch (1.$SwitchMap$com$dianping$cat$report$page$logview$Action[payload.getAction().ordinal()]) {
            case 1: {
                model.setTable(logView);
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private String repliceLogview(String logview) {
        try {
            logview = logview.replaceAll("\\?domain=", "?v=2&domain=");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logview;
    }
}

