/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.logview.service;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.codec.HtmlMessageCodec;
import com.dianping.cat.message.codec.WaterfallMessageCodec;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.storage.MessageBucketManager;
import com.dianping.cat.report.service.BaseHistoricalModelService;
import com.dianping.cat.report.service.ModelRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import org.unidal.cat.message.storage.hdfs.HdfsBucketManager;
import org.unidal.lookup.annotation.Inject;

public class HistoricalMessageService
extends BaseHistoricalModelService<String> {
    @Inject
    private HdfsBucketManager m_bucketManager;
    @Inject(type=MessageBucketManager.class, value={"hdfs"})
    private MessageBucketManager m_hdfsBucketManager;
    private WaterfallMessageCodec m_waterfall = new WaterfallMessageCodec();
    private HtmlMessageCodec m_html = new HtmlMessageCodec();

    public HistoricalMessageService() {
        super("logview");
    }

    protected String buildModel(ModelRequest request) throws Exception {
        String result = this.buildNewMessageModel(request);
        if (result == null) {
            result = this.buildOldMessageModel(request);
        }
        return result;
    }

    protected String buildOldMessageModel(ModelRequest request) throws Exception {
        String messageId = request.getProperty("messageId");
        Cat.logEvent((String)"LoadMessage", (String)"messageTree", (String)"0", (String)messageId);
        MessageTree tree = this.m_hdfsBucketManager.loadMessage(messageId);
        if (tree != null) {
            return this.toString(request, tree);
        }
        return null;
    }

    protected String buildNewMessageModel(ModelRequest request) throws Exception {
        String messageId = request.getProperty("messageId");
        Cat.logEvent((String)"LoadMessage", (String)"messageTree", (String)"0", (String)messageId);
        MessageId id = MessageId.parse((String)messageId);
        MessageTree tree = this.m_bucketManager.loadMessage(id);
        if (tree != null) {
            return this.toString(request, tree);
        }
        return null;
    }

    public boolean isEligable(ModelRequest request) {
        boolean eligibale = request.getPeriod().isHistorical();
        return eligibale;
    }

    protected String toString(ModelRequest request, MessageTree tree) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(8192);
        if (tree.getMessage() instanceof Transaction && request.getProperty("waterfall", "false").equals("true")) {
            this.m_waterfall.encode(tree, buf);
        } else {
            this.m_html.encode(tree, buf);
        }
        try {
            buf.readInt();
            return buf.toString(Charset.forName("utf-8"));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

