/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.matrix;

import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.matrix.Context;
import com.dianping.cat.report.page.matrix.DisplayMatrix;
import com.dianping.cat.report.page.matrix.Handler;
import com.dianping.cat.report.page.matrix.JspViewer;
import com.dianping.cat.report.page.matrix.Model;
import com.dianping.cat.report.page.matrix.Payload;
import com.dianping.cat.report.page.matrix.service.MatrixReportService;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.Action;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private MatrixReportService m_reportService;
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject(type=ModelService.class, value={"matrix"})
    private ModelService<MatrixReport> m_service;

    private MatrixReport getHourlyReport(Payload payload) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("ip", ipAddress);
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            MatrixReport report = (MatrixReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligable matrix service registered for " + request + "!");
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="matrix")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="matrix")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        model.setAction((Action)payload.getAction());
        this.normalize(model, payload);
        switch (1.$SwitchMap$com$dianping$cat$report$page$matrix$Action[payload.getAction().ordinal()]) {
            case 1: {
                this.showSummarizeReport(model, payload);
                break;
            }
            case 2: {
                MatrixReport report = this.getHourlyReport(payload);
                model.setReport(report);
                model.setMatrix(new DisplayMatrix(report).setSortBy(payload.getSortBy()));
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        model.setPage((Page)ReportPage.MATRIX);
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
    }

    private void showSummarizeReport(Model model, Payload payload) {
        Date end;
        Date start;
        String domain = payload.getDomain();
        MatrixReport matrixReport = (MatrixReport)this.m_reportService.queryReport(domain, start = payload.getHistoryStartDate(), end = payload.getHistoryEndDate());
        if (matrixReport == null) {
            return;
        }
        matrixReport.setStartTime(start);
        matrixReport.setEndTime(end);
        model.setReport(matrixReport);
        model.setMatrix(new DisplayMatrix(matrixReport).setSortBy(payload.getSortBy()));
    }
}

