/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.matrix.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.matrix.MatrixReportMerger;
import com.dianping.cat.consumer.matrix.model.IVisitor;
import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.consumer.matrix.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentEntity;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentEntity;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Named;

@Named
public class MatrixReportService
extends AbstractReportService<MatrixReport> {
    public MatrixReport makeReport(String domain, Date start, Date end) {
        MatrixReport report = new MatrixReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public MatrixReport queryDailyReport(String domain, Date start, Date end) {
        MatrixReportMerger merger = new MatrixReportMerger(new MatrixReport(domain));
        long endTime = end.getTime();
        String name = "matrix";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, new Date(startTime), DailyReportEntity.READSET_FULL);
                MatrixReport reportModel = this.queryFromDailyBinary(report.getId(), domain);
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (DalNotFoundException report) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        MatrixReport matrixReport = merger.getMatrixReport();
        matrixReport.setStartTime(start);
        matrixReport.setEndTime(end);
        return matrixReport;
    }

    private MatrixReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new MatrixReport(domain);
    }

    private MatrixReport queryFromHourlyBinary(int id, Date period, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, period, HourlyReportContentEntity.READSET_CONTENT);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new MatrixReport(domain);
    }

    private MatrixReport queryFromMonthlyBinary(int id, String domain) throws DalException {
        MonthlyReportContent content = this.m_monthlyReportContentDao.findByPK(id, MonthlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new MatrixReport(domain);
    }

    private MatrixReport queryFromWeeklyBinary(int id, String domain) throws DalException {
        WeeklyReportContent content = this.m_weeklyReportContentDao.findByPK(id, WeeklyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new MatrixReport(domain);
    }

    public MatrixReport queryHourlyReport(String domain, Date start, Date end) {
        MatrixReportMerger merger = new MatrixReportMerger(new MatrixReport(domain));
        long endTime = end.getTime();
        String name = "matrix";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    MatrixReport reportModel = this.queryFromHourlyBinary(report.getId(), report.getPeriod(), domain);
                    reportModel.accept((IVisitor)merger);
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        MatrixReport matrixReport = merger.getMatrixReport();
        matrixReport.setStartTime(start);
        matrixReport.setEndTime(new Date(end.getTime() - 1L));
        return matrixReport;
    }

    public MatrixReport queryMonthlyReport(String domain, Date start) {
        try {
            MonthlyReport entity = this.m_monthlyReportDao.findReportByDomainNamePeriod(start, domain, "matrix", MonthlyReportEntity.READSET_FULL);
            return this.queryFromMonthlyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new MatrixReport(domain);
    }

    public MatrixReport queryWeeklyReport(String domain, Date start) {
        try {
            WeeklyReport entity = this.m_weeklyReportDao.findReportByDomainNamePeriod(start, domain, "matrix", WeeklyReportEntity.READSET_FULL);
            return this.queryFromWeeklyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return new MatrixReport(domain);
    }
}

