/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.metric.task;

import com.dianping.cat.report.page.metric.task.BaselineCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unidal.lookup.annotation.Named;

@Named(type=BaselineCreator.class)
public class DefaultBaselineCreator
implements BaselineCreator {
    public double computeAvg(List<Double> data) {
        Collections.sort(data);
        int length = data.size();
        double value = 0.0;
        int middle = length / 2;
        value = length % 2 == 0 ? (data.get(middle - 1) + data.get(middle)) / 2.0 : data.get(middle);
        int size = 0;
        double sum = 0.0;
        for (double d : data) {
            if (d > value * 3.0 || d < value / 3.0) continue;
            ++size;
            sum += d;
        }
        return sum / (double)size;
    }

    public double[] createBaseLine(List<double[]> valueList, List<Double> weights, int number) {
        double[] result = new double[number];
        for (int i = 0; i < number; ++i) {
            double totalValue = 0.0;
            double totalWeight = 0.0;
            for (int j = 0; j < valueList.size(); ++j) {
                double[] values = valueList.get(j);
                double weight = weights.get(j);
                if (!(values[i] > 0.0)) continue;
                totalValue += values[i] * weight;
                totalWeight += weight;
            }
            if (totalWeight == 0.0) {
                if (i != 0) {
                    result[i] = result[i - 1];
                    continue;
                }
                result[i] = 0.0;
                continue;
            }
            result[i] = totalValue / totalWeight;
        }
        return this.denoise(result, 30);
    }

    public double[] denoise(double[] data, int mixNumber) {
        if (mixNumber <= 2) {
            return data;
        }
        int number = data.length;
        double[] result = new double[number];
        boolean first = true;
        boolean last = false;
        for (int i = 0; i < number - mixNumber; ++i) {
            int k;
            double avg;
            if (i == number - mixNumber - 1) {
                last = true;
            }
            ArrayList<Double> mixNumbers = new ArrayList<Double>();
            for (int j = 0; j < mixNumber; ++j) {
                int position = i + j;
                mixNumbers.add(data[position]);
            }
            result[i + mixNumber / 2] = avg = this.computeAvg(mixNumbers);
            if (first) {
                first = false;
                for (k = 0; k < mixNumber / 2; ++k) {
                    result[k] = avg;
                }
            }
            if (!last) continue;
            for (k = i + mixNumber / 2 + 1; k < number; ++k) {
                result[k] = avg;
            }
        }
        return result;
    }
}

