/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.model;

import com.dianping.cat.Cat;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.model.Action;
import com.dianping.cat.report.page.model.Context;
import com.dianping.cat.report.page.model.Model;
import com.dianping.cat.report.page.model.Payload;
import com.dianping.cat.report.page.transaction.ReportQueryHelp;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.lookup.ContainerHolder;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
extends ContainerHolder
implements Initializable,
PageHandler<Context> {
    public Map<String, LocalModelService> m_localServices;

    private byte[] compress(String str) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(32768);
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(str.getBytes());
        gzip.close();
        return out.toByteArray();
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="model")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OutboundActionMeta(name="model")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        HttpServletResponse httpResponse = ctx.getHttpServletResponse();
        model.setAction((org.unidal.web.mvc.Action)Action.XML);
        model.setPage((Page)ReportPage.MODEL);
        try {
            this.setReportQueryParams(model);
            String report = payload.getReport();
            String domain = payload.getDomain();
            ModelPeriod period = payload.getPeriod();
            ModelRequest request = null;
            request = "logview".equals(report) ? new ModelRequest(domain, MessageId.parse((String)payload.getMessageId()).getTimestamp()) : new ModelRequest(domain, period.getStartTime());
            String xml = "";
            LocalModelService service = (LocalModelService)this.m_localServices.get(report);
            if (service == null) {
                throw new RuntimeException("Unsupported report: " + report + "!");
            }
            xml = service.getReport(request, period, domain, (ApiPayload)payload);
            if (xml != null) {
                ServletOutputStream outputStream = httpResponse.getOutputStream();
                byte[] compress = this.compress(xml);
                httpResponse.setContentType("application/xml;charset=utf-8");
                httpResponse.addHeader("Content-Encoding", "gzip");
                outputStream.write(compress);
            }
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
        }
        finally {
            ReportQueryHelp.clear();
        }
    }

    public void initialize() throws InitializationException {
        this.m_localServices = this.lookupMap(LocalModelService.class);
    }

    private void setReportQueryParams(Model model) {
        try {
            String params = ((Context)model.getActionContext()).getRequestContext().getUrlMapping().getQueryString();
            String[] arr = params.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String str : arr) {
                String[] args = str.split("=");
                String key = args[0];
                String val = args.length > 1 ? args[1] : null;
                map.put(key, val);
            }
            boolean need = map.get("need") == null;
            String type = (String)map.get("type");
            String name = (String)map.get("name");
            String ip = (String)map.get("ip");
            ReportQueryHelp.set((boolean)need, (String)type, (String)name, (String)ip);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
    }
}

