/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.overload.task;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentDao;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportDao;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.home.dal.report.Overload;
import com.dianping.cat.home.dal.report.OverloadDao;
import com.dianping.cat.report.page.overload.task.CapacityUpdateStatusManager;
import com.dianping.cat.report.page.overload.task.CapacityUpdater;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=CapacityUpdater.class, value="hourly_capacity_updater")
public class HourlyCapacityUpdater
implements CapacityUpdater {
    public static final String ID = "hourly_capacity_updater";
    @Inject
    private HourlyReportContentDao m_hourlyReportContentDao;
    @Inject
    private HourlyReportDao m_hourlyReportDao;
    @Inject
    private OverloadDao m_overloadDao;
    @Inject
    private CapacityUpdateStatusManager m_manager;

    public String getId() {
        return ID;
    }

    public void updateDBCapacity() throws DalException {
        int maxId = this.m_manager.getHourlyStatus();
        while (true) {
            List reports = this.m_hourlyReportContentDao.findOverloadReport(maxId, HourlyReportContentEntity.READSET_LENGTH);
            for (HourlyReportContent content : reports) {
                try {
                    int reportId = content.getReportId();
                    double contentLength = content.getContentLength();
                    if (!(contentLength >= 15.0)) continue;
                    Overload overload = this.m_overloadDao.createLocal();
                    overload.setReportId(reportId);
                    overload.setReportSize(contentLength);
                    overload.setReportType(1);
                    try {
                        HourlyReport hourlyReport = this.m_hourlyReportDao.findByPK(reportId, HourlyReportEntity.READSET_FULL);
                        overload.setPeriod(hourlyReport.getPeriod());
                        this.m_overloadDao.insert(overload);
                    }
                    catch (DalNotFoundException dalNotFoundException) {
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                catch (Exception ex) {
                    Cat.logError((Throwable)ex);
                }
            }
            int size = reports.size();
            if (size == 0) break;
            maxId = ((HourlyReportContent)reports.get(size - 1)).getReportId();
        }
        this.m_manager.updateHourlyStatus(maxId);
    }
}

