/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.overload.task;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentDao;
import com.dianping.cat.core.dal.WeeklyReportContentEntity;
import com.dianping.cat.core.dal.WeeklyReportDao;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.home.dal.report.Overload;
import com.dianping.cat.home.dal.report.OverloadDao;
import com.dianping.cat.report.page.overload.task.CapacityUpdateStatusManager;
import com.dianping.cat.report.page.overload.task.CapacityUpdater;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=CapacityUpdater.class, value="weekly_capacity_updater")
public class WeeklyCapacityUpdater
implements CapacityUpdater {
    public static final String ID = "weekly_capacity_updater";
    @Inject
    private WeeklyReportDao m_weeklyReportDao;
    @Inject
    private WeeklyReportContentDao m_weeklyReportContentDao;
    @Inject
    private OverloadDao m_overloadDao;
    @Inject
    private CapacityUpdateStatusManager m_manager;

    public String getId() {
        return ID;
    }

    public void updateDBCapacity() throws DalException {
        int maxId = this.m_manager.getWeeklyStatus();
        while (true) {
            List reports = this.m_weeklyReportContentDao.findOverloadReport(maxId, WeeklyReportContentEntity.READSET_LENGTH);
            for (WeeklyReportContent content : reports) {
                try {
                    int reportId = content.getReportId();
                    double contentLength = content.getContentLength();
                    if (!(contentLength >= 15.0)) continue;
                    Overload overload = this.m_overloadDao.createLocal();
                    overload.setReportId(reportId);
                    overload.setReportSize(contentLength);
                    overload.setReportType(3);
                    try {
                        WeeklyReport report = this.m_weeklyReportDao.findByPK(reportId, WeeklyReportEntity.READSET_FULL);
                        overload.setPeriod(report.getPeriod());
                        this.m_overloadDao.insert(overload);
                    }
                    catch (DalNotFoundException report) {
                    }
                    catch (Exception e) {
                        Cat.logError((Throwable)e);
                    }
                }
                catch (Exception ex) {
                    Cat.logError((Throwable)ex);
                }
            }
            int size = reports.size();
            if (size == 0) break;
            maxId = ((WeeklyReportContent)reports.get(size - 1)).getReportId();
        }
        this.m_manager.updateWeeklyStatus(maxId);
    }
}

