/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem;

import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.configuration.server.entity.Domain;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.page.DomainGroupConfigManager;
import com.dianping.cat.report.page.problem.Action;
import com.dianping.cat.report.page.problem.Context;
import com.dianping.cat.report.page.problem.GroupLevelInfo;
import com.dianping.cat.report.page.problem.Handler;
import com.dianping.cat.report.page.problem.JspViewer;
import com.dianping.cat.report.page.problem.LongConfig;
import com.dianping.cat.report.page.problem.Model;
import com.dianping.cat.report.page.problem.Payload;
import com.dianping.cat.report.page.problem.ThreadLevelInfo;
import com.dianping.cat.report.page.problem.service.ProblemReportService;
import com.dianping.cat.report.page.problem.transform.DetailStatistics;
import com.dianping.cat.report.page.problem.transform.HourlyLineChartVisitor;
import com.dianping.cat.report.page.problem.transform.PieGraphChartVisitor;
import com.dianping.cat.report.page.problem.transform.ProblemStatistics;
import com.dianping.cat.report.page.problem.transform.ProblemTrendGraphBuilder;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    private static final String DETAIL = "detail";
    private static final String VIEW = "view";
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private ServerConfigManager m_manager;
    @Inject
    private ProblemReportService m_reportService;
    @Inject(type=ModelService.class, value={"problem"})
    private ModelService<ProblemReport> m_service;
    @Inject
    private DomainGroupConfigManager m_configManager;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private JsonBuilder m_jsonBuilder;

    private void buildDefaultThreshold(Model model, Payload payload) {
        Map domains = this.m_manager.getLongConfigDomains();
        Domain d = (Domain)domains.get(payload.getDomain());
        if (d != null) {
            int longSqlTime;
            int longUrlTime;
            int n = longUrlTime = d.getUrlThreshold() == null ? this.m_manager.getLongUrlDefaultThreshold() : d.getUrlThreshold().intValue();
            if (longUrlTime != 500 && longUrlTime != 1000 && longUrlTime != 2000 && longUrlTime != 3000 && longUrlTime != 4000 && longUrlTime != 5000) {
                double sec = (double)longUrlTime / 1000.0;
                DecimalFormat nf = new DecimalFormat("#.##");
                String option = "<option value=\"" + longUrlTime + "\">" + nf.format(sec) + " Sec</option>";
                model.setDefaultThreshold(option);
            }
            if ((longSqlTime = d.getSqlThreshold().intValue()) != 100 && longSqlTime != 500 && longSqlTime != 1000) {
                double sec = longSqlTime;
                DecimalFormat nf = new DecimalFormat("#");
                String option = "<option value=\"" + longSqlTime + "\">" + nf.format(sec) + " ms</option>";
                model.setDefaultSqlThreshold(option);
            }
        }
    }

    private void buildDistributionChart(Model model, Payload payload, ProblemReport report) {
        if (payload.getIpAddress().equalsIgnoreCase("All")) {
            PieGraphChartVisitor pieChart = new PieGraphChartVisitor(payload.getType(), payload.getStatus());
            pieChart.visitProblemReport(report);
            model.setDistributionChart(pieChart.getPieChart().getJsonString());
        }
    }

    private ProblemReport filterReportByGroup(ProblemReport report, String domain, String group) {
        List ips = this.m_configManager.queryIpByDomainAndGroup(domain, group);
        ArrayList<String> removes = new ArrayList<String>();
        for (Machine machine : report.getMachines().values()) {
            String ip = machine.getIp();
            if (ips.contains(ip)) continue;
            removes.add(ip);
        }
        for (String ip : removes) {
            report.getMachines().remove(ip);
        }
        return report;
    }

    private int getHour(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return cal.get(11);
    }

    private ProblemReport getHourlyReport(Payload payload, String queryType) {
        String domain = payload.getDomain();
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("queryType", queryType);
        if (!"All".equals(payload.getIpAddress())) {
            request.setProperty("ip", payload.getIpAddress());
        }
        if (!StringUtils.isEmpty((String)payload.getType())) {
            request.setProperty("type", payload.getType());
        }
        if (!StringUtils.isEmpty((String)payload.getStatus())) {
            request.setProperty("name", payload.getStatus());
        }
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            ProblemReport report = (ProblemReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligible problem service registered for " + request + "!");
    }

    private String getIpAddress(ProblemReport report, Payload payload) {
        Map machines = report.getMachines();
        String ip = payload.getIpAddress();
        if (!(ip != null && ip.length() != 0 || machines.isEmpty())) {
            ip = (String)machines.keySet().iterator().next();
        }
        return ip;
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="p")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="p")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        this.normalize(model, payload);
        ProblemReport report = null;
        ProblemStatistics problemStatistics = new ProblemStatistics();
        String ip = model.getIpAddress();
        LongConfig longConfig = new LongConfig();
        Action action = payload.getAction();
        String domain = payload.getDomain();
        String group = payload.getGroup();
        longConfig.setSqlThreshold(payload.getSqlThreshold()).setUrlThreshold(payload.getUrlThreshold()).setServiceThreshold(payload.getServiceThreshold());
        longConfig.setCacheThreshold(payload.getCacheThreshold()).setCallThreshold(payload.getCallThreshold());
        problemStatistics.setLongConfig(longConfig);
        if (StringUtils.isEmpty((String)group)) {
            group = this.m_configManager.queryDefaultGroup(domain);
            payload.setGroup(group);
        }
        model.setGroupIps(this.m_configManager.queryIpByDomainAndGroup(domain, group));
        model.setGroups(this.m_configManager.queryDomainGroup(payload.getDomain()));
        switch (1.$SwitchMap$com$dianping$cat$report$page$problem$Action[action.ordinal()]) {
            case 1: {
                report = this.getHourlyReport(payload, VIEW);
                if (ip.equals("All")) {
                    problemStatistics.setAllIp(true);
                } else {
                    problemStatistics.setIp(ip);
                }
                problemStatistics.visitProblemReport(report);
                model.setReport(report);
                model.setAllStatistics(problemStatistics);
                break;
            }
            case 2: {
                report = this.showSummarizeReport(model, payload);
                if (ip.equals("All")) {
                    problemStatistics.setAllIp(true);
                    problemStatistics.visitProblemReport(report);
                } else {
                    problemStatistics.setIp(ip);
                    problemStatistics.visitProblemReport(report);
                }
                model.setReport(report);
                model.setAllStatistics(problemStatistics);
                break;
            }
            case 3: {
                report = this.showSummarizeReport(model, payload);
                this.buildDistributionChart(model, payload, report);
                new ProblemTrendGraphBuilder().buildTrendGraph(model, payload, report);
                break;
            }
            case 4: {
                report = this.showHourlyReport(model, payload);
                if (report == null) break;
                model.setGroupLevelInfo(new GroupLevelInfo(model).display(report));
                break;
            }
            case 5: {
                report = this.getHourlyReport(payload, DETAIL);
                String type = payload.getType();
                String state = payload.getStatus();
                Date start = report.getStartTime();
                HourlyLineChartVisitor vistor = new HourlyLineChartVisitor(ip, type, state, start);
                vistor.visitProblemReport(report);
                model.setReport(report);
                model.setErrorsTrend(this.m_jsonBuilder.toJson((Object)vistor.getGraphItem()));
                this.buildDistributionChart(model, payload, report);
                break;
            }
            case 6: {
                report = this.getHourlyReport(payload, VIEW);
                report = this.filterReportByGroup(report, domain, group);
                model.setReport(report);
                if (ip.equals("All")) {
                    problemStatistics.setAllIp(true);
                } else {
                    problemStatistics.setIp(ip);
                }
                problemStatistics.visitProblemReport(report);
                model.setReport(report);
                model.setAllStatistics(problemStatistics);
                break;
            }
            case 7: {
                report = this.getHourlyReport(payload, DETAIL);
                report = this.filterReportByGroup(report, domain, group);
                String type = payload.getType();
                String state = payload.getStatus();
                Date start = report.getStartTime();
                HourlyLineChartVisitor vistor = new HourlyLineChartVisitor("All", type, state, start);
                vistor.visitProblemReport(report);
                model.setErrorsTrend(this.m_jsonBuilder.toJson((Object)vistor.getGraphItem()));
                model.setReport(report);
                this.buildDistributionChart(model, payload, report);
                break;
            }
            case 8: {
                report = this.showSummarizeReport(model, payload);
                report = this.filterReportByGroup(report, domain, group);
                if (ip.equals("All")) {
                    problemStatistics.setAllIp(true);
                    problemStatistics.visitProblemReport(report);
                } else {
                    problemStatistics.setIp(ip);
                    problemStatistics.visitProblemReport(report);
                }
                model.setReport(report);
                model.setAllStatistics(problemStatistics);
                break;
            }
            case 9: {
                report = this.showSummarizeReport(model, payload);
                report = this.filterReportByGroup(report, domain, group);
                this.buildDistributionChart(model, payload, report);
                new ProblemTrendGraphBuilder().buildTrendGraph(model, payload, report);
                break;
            }
            case 10: {
                report = this.showHourlyReport(model, payload);
                String groupName = payload.getGroupName();
                model.setGroupName(groupName);
                if (report == null) break;
                model.setThreadLevelInfo(new ThreadLevelInfo(model, groupName).display(report));
                break;
            }
            case 11: {
                this.showDetail(model, payload);
            }
        }
        this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
    }

    private void normalize(Model model, Payload payload) {
        this.buildDefaultThreshold(model, payload);
        model.setPage((Page)ReportPage.PROBLEM);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
    }

    private void showDetail(Model model, Payload payload) {
        String ipAddress = payload.getIpAddress();
        model.setDate(payload.getDate());
        model.setIpAddress(ipAddress);
        model.setGroupName(payload.getGroupName());
        model.setCurrentMinute(payload.getMinute());
        model.setThreadId(payload.getThreadId());
        ProblemReport report = this.getHourlyReport(payload, DETAIL);
        if (report == null) {
            return;
        }
        model.setReport(report);
        DetailStatistics detail = new DetailStatistics();
        detail.setIp(ipAddress).setMinute(payload.getMinute());
        detail.setGroupName(payload.getGroupName()).setThreadId(payload.getThreadId());
        detail.visitProblemReport(report);
        model.setDetailStatistics(detail);
    }

    private ProblemReport showHourlyReport(Model model, Payload payload) {
        ModelPeriod period = payload.getPeriod();
        model.setDate(payload.getDate());
        if (period.isCurrent()) {
            Calendar cal = Calendar.getInstance();
            int minute = cal.get(12);
            model.setLastMinute(minute);
        } else {
            model.setLastMinute(59);
        }
        model.setHour(this.getHour(model.getLongDate()));
        ProblemReport report = this.getHourlyReport(payload, DETAIL);
        if (report != null) {
            String ip = this.getIpAddress(report, payload);
            model.setIpAddress(ip);
            model.setReport(report);
        }
        return report;
    }

    private ProblemReport showSummarizeReport(Model model, Payload payload) {
        String domain = model.getDomain();
        Date start = payload.getHistoryStartDate();
        Date end = payload.getHistoryEndDate();
        ProblemReport problemReport = (ProblemReport)this.m_reportService.queryReport(domain, start, end);
        return problemReport;
    }
}

