/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.problem.transform;

import com.dianping.cat.consumer.problem.model.entity.Duration;
import com.dianping.cat.consumer.problem.model.entity.Entity;
import com.dianping.cat.consumer.problem.model.entity.JavaThread;
import com.dianping.cat.consumer.problem.model.entity.Machine;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.entity.Segment;
import com.dianping.cat.consumer.problem.model.transform.BaseVisitor;
import com.dianping.cat.report.graph.PieChart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.unidal.lookup.util.StringUtils;

public class PieGraphChartVisitor
extends BaseVisitor {
    private String m_type;
    private String m_status;
    private Map<String, Integer> m_items = new HashMap();
    private String m_ip;

    public PieGraphChartVisitor(String type, String status) {
        this.m_type = type;
        this.m_status = status;
    }

    public PieChart getPieChart() {
        PieChart chart = new PieChart();
        ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
        for (Map.Entry entry : this.m_items.entrySet()) {
            PieChart.Item item = new PieChart.Item();
            item.setNumber((double)((Integer)entry.getValue()).intValue()).setTitle((String)entry.getKey());
            items.add(item);
        }
        chart.addItems(items);
        return chart;
    }

    public void visitDuration(Duration duration) {
        int count = duration.getCount();
        Integer old = (Integer)this.m_items.get(this.m_ip);
        if (old == null) {
            this.m_items.put(this.m_ip, count);
        } else {
            this.m_items.put(this.m_ip, count + old);
        }
    }

    public void visitEntity(Entity entity) {
        String type = entity.getType();
        String name = entity.getStatus();
        if (type.equals(this.m_type) && (StringUtils.isEmpty((String)this.m_status) || name.equals(this.m_status))) {
            super.visitEntity(entity);
        }
    }

    public void visitMachine(Machine machine) {
        this.m_ip = machine.getIp();
        super.visitMachine(machine);
    }

    public void visitProblemReport(ProblemReport problemReport) {
        super.visitProblemReport(problemReport);
    }

    public void visitSegment(Segment segment) {
        super.visitSegment(segment);
    }

    public void visitThread(JavaThread thread) {
        super.visitThread(thread);
    }
}

