/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.service;

import com.dianping.cat.Cat;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.home.service.client.entity.ClientReport;
import com.dianping.cat.home.service.client.transform.DefaultNativeParser;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Named;

@Named
public class ClientReportService
extends AbstractReportService<ClientReport> {
    public ClientReport makeReport(String domain, Date start, Date end) {
        ClientReport report = new ClientReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    public ClientReport queryDailyReport(String domain, Date start, Date end) {
        long startTime = start.getTime();
        String name = "client";
        try {
            DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, new Date(startTime), DailyReportEntity.READSET_FULL);
            return this.queryFromDailyBinary(report.getId(), domain);
        }
        catch (DalNotFoundException report) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        ClientReport report = new ClientReport("cat");
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    private ClientReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new ClientReport(domain);
    }

    public ClientReport queryHourlyReport(String domain, Date start, Date end) {
        throw new RuntimeException("Client report service do not suppot queryHourlyReport feature");
    }

    public ClientReport queryMonthlyReport(String domain, Date start) {
        throw new RuntimeException("Client report service do not suppot queryMonthlyReport feature");
    }

    public ClientReport queryWeeklyReport(String domain, Date start) {
        throw new RuntimeException("Client report service do not suppot queryWeeklyReport feature");
    }
}

