/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.heavy;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.matrix.model.entity.MatrixReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.home.heavy.IVisitor;
import com.dianping.cat.home.heavy.entity.HeavyReport;
import com.dianping.cat.home.heavy.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.matrix.service.MatrixReportService;
import com.dianping.cat.report.page.statistics.service.HeavyReportService;
import com.dianping.cat.report.page.statistics.task.heavy.HeavyReportMerger;
import com.dianping.cat.report.page.statistics.task.heavy.MatrixReportVisitor;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.Date;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="heavy")
public class HeavyReportBuilder
implements TaskBuilder {
    public static final String ID = "heavy";
    @Inject
    protected HeavyReportService m_reportService;
    @Inject
    protected MatrixReportService m_matrixReportService;
    @Inject
    private ServerFilterConfigManager m_configManager;

    public boolean buildDailyTask(String name, String domain, Date period) {
        HeavyReport heavyReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((HeavyReport)heavyReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    public boolean buildHourlyTask(String name, String domain, Date start) {
        HeavyReport heavyReport = new HeavyReport("cat");
        MatrixReportVisitor visitor = new MatrixReportVisitor().setReport(heavyReport);
        Date end = new Date(start.getTime() + 3600000L);
        Set domains = this.m_reportService.queryAllDomainNames(start, end, "matrix");
        heavyReport.setStartTime(start);
        heavyReport.setEndTime(end);
        for (String domainName : domains) {
            if (!this.m_configManager.validateDomain(domainName)) continue;
            MatrixReport matrixReport = (MatrixReport)this.m_matrixReportService.queryReport(domainName, start, end);
            visitor.visitMatrixReport(matrixReport);
        }
        HourlyReport report = new HourlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(start);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((HeavyReport)heavyReport);
        return this.m_reportService.insertHourlyReport(report, binaryContent);
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        HeavyReport heavyReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((HeavyReport)heavyReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        HeavyReport heavyReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((HeavyReport)heavyReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private HeavyReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        HeavyReportMerger merger = new HeavyReportMerger(new HeavyReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                HeavyReport reportModel = (HeavyReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        HeavyReport heavyReport = merger.getHeavyReport();
        heavyReport.setStartTime(start);
        heavyReport.setEndTime(end);
        return heavyReport;
    }

    private HeavyReport queryHourlyReportsByDuration(String name, String domain, Date period, Date endDate) {
        long endTime = endDate.getTime();
        HeavyReportMerger merger = new HeavyReportMerger(new HeavyReport(domain));
        for (long startTime = period.getTime(); startTime < endTime; startTime += 3600000L) {
            Date date = new Date(startTime);
            HeavyReport reportModel = (HeavyReport)this.m_reportService.queryReport(domain, date, new Date(date.getTime() + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        HeavyReport heavyReport = merger.getHeavyReport();
        return heavyReport;
    }
}

