/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.service;

import com.dianping.cat.consumer.transaction.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.consumer.transaction.model.transform.BaseVisitor;
import com.dianping.cat.home.service.client.entity.ClientReport;
import com.dianping.cat.home.service.client.entity.Domain;
import com.dianping.cat.home.service.client.entity.Method;

public class ClientReportStatistics
extends BaseVisitor {
    private ClientReport m_clientReport = new ClientReport("cat");
    private String m_domain;

    public ClientReport getClienReport() {
        return this.m_clientReport;
    }

    public void visitMachine(Machine machine) {
        if ("All".equals(machine.getIp())) {
            super.visitMachine(machine);
        }
    }

    public void visitName(TransactionName name) {
        Domain domain = this.m_clientReport.findOrCreateDomain(this.m_domain);
        domain.incTotalCount(name.getTotalCount());
        domain.incFailureCount(name.getFailCount());
        domain.incSum(name.getSum());
        domain.setFailurePercent((double)domain.getFailureCount() * 1.0 / (double)domain.getTotalCount());
        domain.setAvg(domain.getSum() / (double)domain.getTotalCount());
        String interf = name.getId();
        Method method = domain.findOrCreateMethod(interf);
        method.incTotalCount(name.getTotalCount());
        method.incFailureCount(name.getFailCount());
        method.incSum(name.getSum());
        method.setFailurePercent((double)method.getFailureCount() * 1.0 / (double)method.getTotalCount());
        method.setAvg(method.getSum() / (double)method.getTotalCount());
        method.setTimeout(name.getMax());
        super.visitName(name);
    }

    public void visitTransactionReport(TransactionReport transactionReport) {
        this.m_domain = transactionReport.getDomain();
        this.m_clientReport.setStartTime(transactionReport.getStartTime());
        this.m_clientReport.setEndTime(transactionReport.getEndTime());
        super.visitTransactionReport(transactionReport);
    }

    public void visitType(TransactionType type) {
        if ("PigeonCall".equals(type.getId()) || "Call".equals(type.getId())) {
            super.visitType(type);
        }
    }
}

