/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.service;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.cross.model.entity.CrossReport;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.home.service.IVisitor;
import com.dianping.cat.home.service.entity.Domain;
import com.dianping.cat.home.service.entity.ServiceReport;
import com.dianping.cat.home.service.transform.DefaultNativeBuilder;
import com.dianping.cat.report.page.cross.display.ProjectInfo;
import com.dianping.cat.report.page.cross.display.TypeDetailInfo;
import com.dianping.cat.report.page.cross.service.CrossReportService;
import com.dianping.cat.report.page.statistics.service.ServiceReportService;
import com.dianping.cat.report.page.statistics.task.service.ServiceReportMerger;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="service")
public class ServiceReportBuilder
implements TaskBuilder {
    public static final String ID = "service";
    @Inject
    protected ServiceReportService m_reportService;
    @Inject
    protected CrossReportService m_crossReportService;
    Map<String, Domain> stat = new HashMap();
    @Inject
    private ServerFilterConfigManager m_configManger;

    public boolean buildDailyTask(String name, String domain, Date period) {
        ServiceReport serviceReport = this.queryHourlyReportsByDuration(name, domain, period, TaskHelper.tomorrowZero((Date)period));
        DailyReport report = new DailyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ServiceReport)serviceReport);
        return this.m_reportService.insertDailyReport(report, binaryContent);
    }

    public boolean buildHourlyTask(String name, String domain, Date start) {
        ServiceReport serviceReport = new ServiceReport("cat");
        Date end = new Date(start.getTime() + 3600000L);
        Set domains = this.m_reportService.queryAllDomainNames(start, end, "cross");
        for (String domainName : domains) {
            if (!this.m_configManger.validateDomain(domainName)) continue;
            CrossReport crossReport = (CrossReport)this.m_crossReportService.queryReport(domainName, start, end);
            ProjectInfo projectInfo = new ProjectInfo(3600000L);
            projectInfo.setClientIp("All");
            projectInfo.visitCrossReport(crossReport);
            Collection callInfos = projectInfo.getCallProjectsInfo();
            for (TypeDetailInfo typeInfo : callInfos) {
                if (this.validataService(typeInfo)) continue;
                this.merge(serviceReport.findOrCreateDomain(typeInfo.getProjectName()), typeInfo);
            }
        }
        HourlyReport report = new HourlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(start);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ServiceReport)serviceReport);
        return this.m_reportService.insertHourlyReport(report, binaryContent);
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        ServiceReport serviceReport = this.queryDailyReportsByDuration(domain, period, TaskHelper.nextMonthStart((Date)period));
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ServiceReport)serviceReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        ServiceReport serviceReport = this.queryDailyReportsByDuration(domain, period, new Date(period.getTime() + 604800000L));
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(domain);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((ServiceReport)serviceReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    public void merge(Domain domain, TypeDetailInfo info) {
        domain.setTotalCount(domain.getTotalCount() + info.getTotalCount());
        domain.setFailureCount(domain.getFailureCount() + info.getFailureCount());
        domain.setSum(domain.getSum() + info.getSum());
        if (domain.getTotalCount() > 0L) {
            domain.setAvg(domain.getSum() / (double)domain.getTotalCount());
            domain.setFailurePercent((double)domain.getFailureCount() * 1.0 / (double)domain.getTotalCount());
        }
    }

    private ServiceReport queryDailyReportsByDuration(String domain, Date start, Date end) {
        long endTime = end.getTime();
        ServiceReportMerger merger = new ServiceReportMerger(new ServiceReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                ServiceReport reportModel = (ServiceReport)this.m_reportService.queryReport(domain, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        ServiceReport serviceReport = merger.getServiceReport();
        serviceReport.setStartTime(start);
        serviceReport.setEndTime(end);
        return serviceReport;
    }

    private ServiceReport queryHourlyReportsByDuration(String name, String domain, Date start, Date end) {
        long endTime = end.getTime();
        ServiceReportMerger merger = new ServiceReportMerger(new ServiceReport(domain));
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            Date date = new Date(startTime);
            ServiceReport reportModel = (ServiceReport)this.m_reportService.queryReport(domain, date, new Date(date.getTime() + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        ServiceReport serviceReport = merger.getServiceReport();
        serviceReport.setStartTime(start);
        serviceReport.setEndTime(end);
        return serviceReport;
    }

    private boolean validataService(TypeDetailInfo typeInfo) {
        return typeInfo.getProjectName().equalsIgnoreCase("AllServers") || typeInfo.getProjectName().equalsIgnoreCase("UnknownProject");
    }
}

