/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.statistics.task.utilization;

import com.dianping.cat.home.utilization.entity.ApplicationState;
import com.dianping.cat.home.utilization.entity.Domain;
import com.dianping.cat.home.utilization.entity.MachineState;
import com.dianping.cat.home.utilization.entity.UtilizationReport;
import com.dianping.cat.home.utilization.transform.DefaultMerger;

public class UtilizationReportMerger
extends DefaultMerger {
    public UtilizationReportMerger(UtilizationReport utilizationReport) {
        super(utilizationReport);
    }

    protected void mergeApplicationState(ApplicationState to, ApplicationState from) {
        to.setAvg95((to.getAvg95() * (double)to.getCount() + from.getAvg95() * (double)from.getCount()) / (double)(to.getCount() + from.getCount()));
        if (from.getMaxQps() > to.getMaxQps()) {
            to.setMaxQps(from.getMaxQps());
        }
        to.setSum(to.getSum() + from.getSum());
        to.setCount(to.getCount() + from.getCount());
        to.setFailureCount(to.getFailureCount() + from.getFailureCount());
        to.setAvg(to.getSum() / (double)to.getCount());
        to.setFailurePercent((double)to.getFailureCount() * 1.0 / (double)to.getCount());
    }

    protected void mergeDomain(Domain old, Domain domain) {
        if (domain.getMachineNumber() > old.getMachineNumber()) {
            old.setMachineNumber(domain.getMachineNumber());
        }
    }

    protected void mergeMachineState(MachineState to, MachineState from) {
        if (from.getAvgMax() > to.getAvgMax()) {
            to.setAvgMax(from.getAvgMax());
        }
        to.setSum(to.getSum() + from.getSum());
        to.setCount(to.getCount() + from.getCount());
        to.setAvg(to.getSum() * 1.0 / (double)to.getCount());
    }

    protected void mergeUtilizationReport(UtilizationReport old, UtilizationReport bugReport) {
        super.mergeUtilizationReport(old, bugReport);
    }

    public void visitUtilizationReport(UtilizationReport utilizationReport) {
        UtilizationReport oldReport = this.getUtilizationReport();
        oldReport.setDomain(utilizationReport.getDomain());
        oldReport.setStartTime(utilizationReport.getStartTime());
        oldReport.setEndTime(utilizationReport.getEndTime());
        super.visitUtilizationReport(utilizationReport);
    }
}

