/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.display;

import com.dianping.cat.Cat;
import com.dianping.cat.alarm.Alert;
import com.dianping.cat.alarm.service.AlertService;
import com.dianping.cat.alarm.spi.AlertLevel;
import com.dianping.cat.home.storage.alert.entity.Detail;
import com.dianping.cat.home.storage.alert.entity.Machine;
import com.dianping.cat.home.storage.alert.entity.Operation;
import com.dianping.cat.home.storage.alert.entity.Storage;
import com.dianping.cat.home.storage.alert.entity.StorageAlertInfo;
import com.dianping.cat.home.storage.alert.entity.Target;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class StorageAlertInfoBuilder {
    @Inject
    private AlertService m_alertService;
    private SimpleDateFormat m_sdf = new SimpleDateFormat("HH:mm");

    public int buildLevel(int level, int other) {
        return level > other ? level : other;
    }

    public Map<String, StorageAlertInfo> buildStorageAlertInfos(Date start, Date end, int minuteCounts, String type, List<Alert> alerts) {
        Map results = this.prepareBlankAlert(start.getTime(), end.getTime(), minuteCounts, type);
        for (Alert alert : alerts) {
            long time = alert.getAlertTime().getTime();
            long current = time - time % 60000L - 60000L;
            Date date = new Date(current);
            StorageAlertInfo alertInfo = (StorageAlertInfo)results.get(this.m_sdf.format(date));
            if (alertInfo != null) {
                this.parseAlertEntity(alert, alertInfo);
                continue;
            }
            Cat.logError((Throwable)new RuntimeException("Error date in alert: " + alert.toString() + ", alert date: " + date));
        }
        return results;
    }

    public StorageAlertInfo makeAlertInfo(String id, Date start) {
        StorageAlertInfo alertInfo = new StorageAlertInfo(id);
        alertInfo.setStartTime(start);
        alertInfo.setEndTime(new Date(start.getTime() + 60000L - 1L));
        return alertInfo;
    }

    public void parseAlertEntity(Alert alert, StorageAlertInfo alertInfo) {
        String name = alert.getDomain();
        List fields = Splitters.by((String)";").split(alert.getMetric());
        String ip = (String)fields.get(0);
        String operation = (String)fields.get(1);
        String target = this.queryTargetTitle((String)fields.get(2));
        AlertLevel alertLevel = AlertLevel.findByName((String)alert.getType());
        int level = alertLevel.getPriority();
        Storage storage = alertInfo.findOrCreateStorage(name);
        storage.incCount();
        storage.setLevel(this.buildLevel(storage.getLevel(), level));
        Machine machine = storage.findOrCreateMachine(ip);
        machine.incCount();
        machine.setLevel(this.buildLevel(machine.getLevel(), level));
        Operation op = machine.findOrCreateOperation(operation);
        op.incCount();
        op.setLevel(this.buildLevel(op.getLevel(), level));
        Target tg = op.findOrCreateTarget(target);
        tg.incCount();
        tg.setLevel(this.buildLevel(tg.getLevel(), level));
        tg.getDetails().add(new Detail(alert.getContent()).setLevel(level));
    }

    private Map<String, StorageAlertInfo> prepareBlankAlert(long start, long end, int minuteCounts, String type) {
        LinkedHashMap<String, StorageAlertInfo> results = new LinkedHashMap<String, StorageAlertInfo>();
        for (long s = start; s <= end; s += 60000L) {
            String title = this.m_sdf.format(new Date(s));
            StorageAlertInfo blankAlertInfo = this.makeAlertInfo(type, new Date(start));
            results.put(title, blankAlertInfo);
        }
        return results;
    }

    private String queryTargetTitle(String target) {
        if ("avg".equals(target)) {
            return "\u54cd\u5e94\u65f6\u95f4";
        }
        if ("error".equals(target)) {
            return "\u9519\u8bef\u6570";
        }
        if ("errorPercent".equals(target)) {
            return "\u9519\u8bef\u7387";
        }
        return target;
    }
}

