/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.service;

import com.dianping.cat.consumer.storage.StorageReportMerger;
import com.dianping.cat.consumer.storage.model.IEntity;
import com.dianping.cat.consumer.storage.model.IVisitor;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.consumer.storage.model.transform.DefaultSaxParser;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.storage.service.LocalStorageService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=LocalModelService.class, value="storage")
public class LocalStorageService
extends LocalModelService<StorageReport> {
    public static final String ID = "storage";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalStorageService() {
        super(ID);
    }

    public String buildReport(ModelRequest request, ModelPeriod period, String id, ApiPayload payload) throws Exception {
        List reports = super.getReport(period, id);
        StorageReport report = null;
        if (reports != null) {
            report = new StorageReport(id);
            StorageReportMerger merger = new StorageReportMerger(report);
            for (StorageReport tmp : reports) {
                tmp.accept((IVisitor)merger);
            }
        }
        if ((report == null || report.getIps().isEmpty()) && period.isLast()) {
            long startTime = request.getStartTime();
            report = this.getReportFromLocalDisk(startTime, id);
        }
        String ipAddress = payload.getIpAddress();
        return new StorageReportFilter(ipAddress).buildXml((IEntity)report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageReport getReportFromLocalDisk(long timestamp, String id) throws Exception {
        StorageReport report = new StorageReport(id);
        StorageReportMerger merger = new StorageReportMerger(report);
        report.setStartTime(new Date(timestamp));
        report.setEndTime(new Date(timestamp + 3600000L - 1L));
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            ReportBucket bucket = null;
            try {
                bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                String xml = bucket.findById(id);
                if (xml != null) {
                    StorageReport tmp = DefaultSaxParser.parse((String)xml);
                    tmp.accept((IVisitor)merger);
                    continue;
                }
                String type = id.substring(id.lastIndexOf("-"));
                HashSet<String> reportIds = new HashSet<String>();
                for (String tmp : bucket.getIds()) {
                    if (!tmp.endsWith(type)) continue;
                    String prefix = tmp.substring(0, tmp.lastIndexOf("-"));
                    reportIds.add(prefix);
                }
                report.getIds().addAll(reportIds);
                continue;
            }
            finally {
                if (bucket != null) {
                    this.m_bucketManager.closeBucket(bucket);
                }
            }
        }
        return report;
    }
}

