/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.storage.StorageReportMerger;
import com.dianping.cat.consumer.storage.model.IVisitor;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.consumer.storage.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.page.storage.task.HistoryStorageReportMerger;
import com.dianping.cat.report.page.storage.task.StorageReportService;
import com.dianping.cat.report.page.storage.transform.StorageMergeHelper;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.report.task.TaskHelper;
import com.dianping.cat.report.task.current.CurrentWeeklyMonthlyReportTask;
import java.util.Date;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="storage")
public class StorageReportBuilder
implements TaskBuilder,
Initializable {
    public static final String ID = "storage";
    @Inject
    protected StorageReportService m_reportService;
    @Inject
    private StorageMergeHelper m_storageMergerHelper;

    public boolean buildDailyTask(String name, String reportId, Date period) {
        try {
            StorageReport storageReport = this.queryHourlyReportsByDuration(reportId, period, TaskHelper.tomorrowZero((Date)period));
            DailyReport report = new DailyReport();
            report.setCreationDate(new Date());
            report.setDomain(reportId);
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(name);
            report.setPeriod(period);
            report.setType(1);
            byte[] binaryContent = DefaultNativeBuilder.build((StorageReport)storageReport);
            return this.m_reportService.insertDailyReport(report, binaryContent);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        throw new RuntimeException("Storage report don't support HourlyReport!");
    }

    public boolean buildMonthlyTask(String name, String reportId, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentMonth()) ? TimeHelper.getCurrentDay() : TaskHelper.nextMonthStart((Date)period);
        StorageReport storageReport = this.queryDailyReportsByDuration(reportId, period, end);
        MonthlyReport report = new MonthlyReport();
        report.setCreationDate(new Date());
        report.setDomain(reportId);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((StorageReport)storageReport);
        return this.m_reportService.insertMonthlyReport(report, binaryContent);
    }

    public boolean buildWeeklyTask(String name, String reportId, Date period) {
        Date end = null;
        end = period.equals(TimeHelper.getCurrentWeek()) ? TimeHelper.getCurrentDay() : new Date(period.getTime() + 604800000L);
        StorageReport storageReport = this.queryDailyReportsByDuration(reportId, period, end);
        WeeklyReport report = new WeeklyReport();
        report.setCreationDate(new Date());
        report.setDomain(reportId);
        report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        report.setName(name);
        report.setPeriod(period);
        report.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((StorageReport)storageReport);
        return this.m_reportService.insertWeeklyReport(report, binaryContent);
    }

    private StorageReport queryDailyReportsByDuration(String reportId, Date start, Date end) {
        long endTime = end.getTime();
        int index = reportId.lastIndexOf("-");
        String name = reportId.substring(0, index);
        String type = reportId.substring(index + 1);
        StorageReport report = new StorageReport(reportId);
        StorageReportMerger merger = new StorageReportMerger(report);
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                StorageReport reportModel = (StorageReport)this.m_reportService.queryReport(reportId, new Date(startTime), new Date(startTime + 86400000L));
                reportModel.accept((IVisitor)merger);
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        StorageReport storageReport = merger.getStorageReport();
        storageReport.setName(name).setType(type);
        storageReport.setStartTime(start).setEndTime(end);
        return storageReport;
    }

    private StorageReport queryHourlyReportsByDuration(String reportId, Date start, Date end) throws DalException {
        long endTime = end.getTime();
        int index = reportId.lastIndexOf("-");
        String name = reportId.substring(0, index);
        String type = reportId.substring(index + 1);
        StorageReport report = new StorageReport(reportId);
        HistoryStorageReportMerger merger = new HistoryStorageReportMerger(report);
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            StorageReport reportModel = (StorageReport)this.m_reportService.queryReport(reportId, new Date(startTime), new Date(startTime + 3600000L));
            reportModel.accept((IVisitor)merger);
        }
        StorageReport storageReport = merger.getStorageReport();
        storageReport.setName(name).setType(type);
        storageReport.setStartTime(start).setEndTime(end);
        return storageReport;
    }

    public void initialize() throws InitializationException {
        CurrentWeeklyMonthlyReportTask.getInstance().register((CurrentWeeklyMonthlyReportTask.CurrentWeeklyMonthlyTask)new /* Unavailable Anonymous Inner Class!! */);
    }
}

