/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.storage.transform;

import com.dianping.cat.consumer.storage.model.entity.Domain;
import com.dianping.cat.consumer.storage.model.entity.Machine;
import com.dianping.cat.consumer.storage.model.entity.Operation;
import com.dianping.cat.consumer.storage.model.entity.Segment;
import com.dianping.cat.consumer.storage.model.entity.StorageReport;
import com.dianping.cat.consumer.storage.model.transform.BaseVisitor;
import java.util.Set;

public class StorageOperationFilter
extends BaseVisitor {
    private StorageReport m_storageReport;
    private String m_currentMachine;
    private String m_currentOperation;
    private String m_currentDomain;
    private Set<String> m_operations;

    public StorageOperationFilter(Set<String> ops) {
        this.m_operations = ops;
    }

    public StorageReport getStorageReport() {
        return this.m_storageReport;
    }

    private void mergeOperation(Operation operation) {
        Operation to = this.m_storageReport.findOrCreateMachine(this.m_currentMachine).findOrCreateDomain(this.m_currentDomain).findOrCreateOperation(this.m_currentOperation);
        to.setCount(to.getCount() + operation.getCount());
        to.setLongCount(to.getLongCount() + operation.getLongCount());
        to.setError(to.getError() + operation.getError());
        to.setSum(to.getSum() + operation.getSum());
        to.setAvg(to.getCount() > 0L ? to.getSum() / (double)to.getCount() : 0.0);
    }

    private void mergeSegment(Segment segment) {
        Segment to = this.m_storageReport.findOrCreateMachine(this.m_currentMachine).findOrCreateDomain(this.m_currentDomain).findOrCreateOperation(this.m_currentOperation).findOrCreateSegment(segment.getId());
        to.setCount(to.getCount() + segment.getCount());
        to.setLongCount(to.getLongCount() + segment.getLongCount());
        to.setError(to.getError() + segment.getError());
        to.setSum(to.getSum() + segment.getSum());
        to.setAvg(to.getCount() > 0L ? to.getSum() / (double)to.getCount() : 0.0);
    }

    public void visitDomain(Domain domain) {
        this.m_currentDomain = domain.getId();
        super.visitDomain(domain);
    }

    public void visitMachine(Machine machine) {
        this.m_currentMachine = machine.getId();
        super.visitMachine(machine);
    }

    public void visitOperation(Operation operation) {
        if (this.m_operations.contains(operation.getId())) {
            this.m_currentOperation = operation.getId();
            this.m_storageReport.getOps().add(this.m_currentOperation);
            this.mergeOperation(operation);
            super.visitOperation(operation);
        }
    }

    public void visitSegment(Segment segment) {
        this.mergeSegment(segment);
        super.visitSegment(segment);
    }

    public void visitStorageReport(StorageReport storageReport) {
        this.m_storageReport = new StorageReport(storageReport.getId());
        this.m_storageReport.setName(storageReport.getName()).setType(storageReport.getType()).setStartTime(storageReport.getStartTime()).setEndTime(storageReport.getEndTime());
        this.m_storageReport.getIds().addAll(storageReport.getIds());
        this.m_storageReport.getIps().addAll(storageReport.getIps());
        super.visitStorageReport(storageReport);
    }
}

