/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.top;

import com.dianping.cat.consumer.transaction.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.Range;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.consumer.transaction.model.transform.BaseVisitor;
import com.dianping.cat.report.page.top.DomainInfo;
import java.text.SimpleDateFormat;

public class TransactionReportVisitor
extends BaseVisitor {
    private DomainInfo m_info;
    private String m_ipAddress;
    private String m_type;
    private String m_date;

    public TransactionReportVisitor(String ipAddress, DomainInfo info, String type) {
        this.m_info = info;
        this.m_type = type;
        this.m_ipAddress = ipAddress;
    }

    public void visitTransactionReport(TransactionReport transactionReport) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:");
        this.m_date = sdf.format(transactionReport.getStartTime());
        super.visitTransactionReport(transactionReport);
    }

    public void visitMachine(Machine machine) {
        String id = machine.getIp();
        if ("All".equals(this.m_ipAddress) || id.equals(this.m_ipAddress)) {
            super.visitMachine(machine);
        }
    }

    public void visitType(TransactionType type) {
        if (type.getId().equals(this.m_type)) {
            super.visitType(type);
        }
    }

    public void visitRange(Range range) {
        int minute = range.getValue();
        String key = "";
        key = minute >= 10 ? this.m_date + minute : this.m_date + '0' + minute;
        DomainInfo.Metric metric = this.m_info.getMetric(key);
        metric.get(this.m_type).setFail((long)range.getFails()).setValue((long)range.getCount(), range.getSum());
    }
}

