/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.transaction.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.mvc.AbstractReportModel;
import com.dianping.cat.mvc.AbstractReportPayload;
import com.dianping.cat.mvc.PayloadNormalizer;
import com.dianping.cat.report.ReportPage;
import com.dianping.cat.report.graph.PieChart;
import com.dianping.cat.report.graph.svg.GraphBuilder;
import com.dianping.cat.report.graph.svg.GraphPayload;
import com.dianping.cat.report.page.DomainGroupConfigManager;
import com.dianping.cat.report.page.transaction.Action;
import com.dianping.cat.report.page.transaction.Context;
import com.dianping.cat.report.page.transaction.DisplayNames;
import com.dianping.cat.report.page.transaction.DisplayTypes;
import com.dianping.cat.report.page.transaction.GraphPayload;
import com.dianping.cat.report.page.transaction.Handler;
import com.dianping.cat.report.page.transaction.JspViewer;
import com.dianping.cat.report.page.transaction.Model;
import com.dianping.cat.report.page.transaction.Payload;
import com.dianping.cat.report.page.transaction.ReportQueryHelp;
import com.dianping.cat.report.page.transaction.XmlViewer;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.page.transaction.transform.DistributionDetailVisitor;
import com.dianping.cat.report.page.transaction.transform.PieGraphChartVisitor;
import com.dianping.cat.report.page.transaction.transform.TransactionMergeHelper;
import com.dianping.cat.report.page.transaction.transform.TransactionTrendGraphBuilder;
import com.dianping.cat.report.service.ModelRequest;
import com.dianping.cat.report.service.ModelResponse;
import com.dianping.cat.report.service.ModelService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private GraphBuilder m_builder;
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private XmlViewer m_xmlViewer;
    @Inject
    private TransactionReportService m_reportService;
    @Inject
    private TransactionMergeHelper m_mergeHelper;
    @Inject
    private PayloadNormalizer m_normalizePayload;
    @Inject
    private DomainGroupConfigManager m_configManager;
    @Inject(type=ModelService.class, value={"transaction"})
    private ModelService<TransactionReport> m_service;

    private void buildDistributionInfo(Model model, String type, String name, TransactionReport report) {
        PieGraphChartVisitor chartVisitor = new PieGraphChartVisitor(type, name);
        DistributionDetailVisitor detailVisitor = new DistributionDetailVisitor(type, name);
        chartVisitor.visitTransactionReport(report);
        detailVisitor.visitTransactionReport(report);
        model.setDistributionChart(chartVisitor.getPieChart().getJsonString());
        model.setDistributionDetails(detailVisitor.getDetails());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTransactionMetaInfo(Model model, Payload payload, TransactionReport report) {
        Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)"buildTransactionMetaInfo");
        try {
            String type = payload.getType();
            String sorted = payload.getSortBy();
            String queryName = payload.getQueryName();
            String ip = payload.getIpAddress();
            if (!StringUtils.isEmpty((String)type)) {
                DisplayNames displayNames = new DisplayNames();
                model.setDisplayNameReport(displayNames.display(sorted, type, ip, report, queryName));
                this.buildTransactionNamePieChart(displayNames.getResults(), model);
            } else {
                model.setDisplayTypeReport(new DisplayTypes().display(sorted, ip, report));
            }
            t.setStatus("0");
        }
        finally {
            t.complete();
        }
    }

    private void buildTransactionNameGraph(Model model, TransactionReport report, String type, String name, String ip) {
        TransactionType t = report.findOrCreateMachine(ip).findOrCreateType(type);
        TransactionName transactionName = t.findOrCreateName(name);
        if (transactionName != null) {
            String graph1 = this.m_builder.build((GraphPayload)new GraphPayload.DurationPayload("\u4e00\u5c0f\u65f6\u5185\u7684\u8017\u65f6\u5206\u5e03", "Duration (ms)", "Count", transactionName));
            String graph2 = this.m_builder.build((GraphPayload)new GraphPayload.HitPayload("\u6bcf\u5206\u949f\u8c03\u7528\u91cf", "Time (min)", "Count", transactionName));
            String graph3 = this.m_builder.build((GraphPayload)new GraphPayload.AverageTimePayload("\u6bcf\u5206\u949f\u5e73\u5747\u5ef6\u65f6", "Time (min)", "Avg (ms)", transactionName));
            String graph4 = this.m_builder.build((GraphPayload)new GraphPayload.FailurePayload("\u6bcf\u5206\u949f\u5931\u8d25\u6570\u91cf", "Time (min)", "Count", transactionName));
            model.setGraph1(graph1);
            model.setGraph2(graph2);
            model.setGraph3(graph3);
            model.setGraph4(graph4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTransactionNamePieChart(List<DisplayNames.TransactionNameModel> names, Model model) {
        Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)"buildTransactionNamePieChart");
        try {
            PieChart chart = new PieChart();
            ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
            for (int i = 1; i < names.size(); ++i) {
                DisplayNames.TransactionNameModel name = names.get(i);
                PieChart.Item item = new PieChart.Item();
                TransactionName transaction = name.getDetail();
                item.setNumber((double)transaction.getTotalCount()).setTitle(transaction.getId());
                items.add(item);
            }
            chart.addItems(items);
            model.setPieChart(new JsonBuilder().toJson((Object)chart));
            t.setStatus("0");
        }
        finally {
            t.complete();
        }
    }

    private TransactionReport filterReportByGroup(TransactionReport report, String domain, String group) {
        List ips = this.m_configManager.queryIpByDomainAndGroup(domain, group);
        ArrayList<String> removes = new ArrayList<String>();
        for (Machine machine : report.getMachines().values()) {
            String ip = machine.getIp();
            if (ips.contains(ip)) continue;
            removes.add(ip);
        }
        for (String ip : removes) {
            report.getMachines().remove(ip);
        }
        return report;
    }

    private TransactionReport getHourlyGraphReport(Model model, Payload payload) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        String name = payload.getName();
        if (name == null || name.length() == 0) {
            name = "*";
        }
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("type", payload.getType()).setProperty("name", name).setProperty("ip", ipAddress);
        ModelResponse response = this.m_service.invoke(request);
        TransactionReport report = (TransactionReport)response.getModel();
        return report;
    }

    private TransactionReport getHourlyReport(Payload payload) {
        String domain = payload.getDomain();
        String ipAddress = payload.getIpAddress();
        String name = payload.getQueryName();
        ModelRequest request = new ModelRequest(domain, payload.getDate()).setProperty("type", payload.getType()).setProperty("name", name).setProperty("ip", ipAddress).setProperty("need", "false");
        if (this.m_service.isEligable(request)) {
            ModelResponse response = this.m_service.invoke(request);
            TransactionReport report = (TransactionReport)response.getModel();
            return report;
        }
        throw new RuntimeException("Internal error: no eligable transaction service registered for " + request + "!");
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="t")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OutboundActionMeta(name="t")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Cat.logMetricForCount((String)"http-request-transaction");
        try {
            Model model = new Model(ctx);
            Payload payload = (Payload)ctx.getPayload();
            this.normalize(model, payload);
            String domain = payload.getDomain();
            Action action = payload.getAction();
            String ipAddress = payload.getIpAddress();
            String group = payload.getGroup();
            String type = payload.getType();
            String name = payload.getName();
            String ip = payload.getIpAddress();
            Date start = payload.getHistoryStartDate();
            Date end = payload.getHistoryEndDate();
            String queryName = payload.getQueryName();
            ReportQueryHelp.set((boolean)true, (String)type, (String)queryName, (String)ip);
            if (StringUtils.isEmpty((String)group)) {
                group = this.m_configManager.queryDefaultGroup(domain);
                payload.setGroup(group);
            }
            model.setGroupIps(this.m_configManager.queryIpByDomainAndGroup(domain, group));
            model.setGroups(this.m_configManager.queryDomainGroup(payload.getDomain()));
            switch (1.$SwitchMap$com$dianping$cat$report$page$transaction$Action[action.ordinal()]) {
                case 1: {
                    ReportQueryHelp.set((boolean)false, (String)type, (String)queryName, (String)ip);
                    TransactionReport report = this.getHourlyReport(payload);
                    report = this.m_mergeHelper.mergeAllMachines(report, ipAddress);
                    if (report == null) break;
                    model.setReport(report);
                    this.buildTransactionMetaInfo(model, payload, report);
                    break;
                }
                case 2: {
                    ReportQueryHelp.set((boolean)false, (String)type, (String)queryName, (String)ip);
                    TransactionReport report = (TransactionReport)this.m_reportService.queryReport(domain, payload.getHistoryStartDate(), payload.getHistoryEndDate());
                    report = this.m_mergeHelper.mergeAllMachines(report, ipAddress);
                    if (report == null) break;
                    model.setReport(report);
                    this.buildTransactionMetaInfo(model, payload, report);
                    break;
                }
                case 3: {
                    TransactionReport report = (TransactionReport)this.m_reportService.queryReport(domain, start, end);
                    if ("All".equalsIgnoreCase(ip)) {
                        this.buildDistributionInfo(model, type, name, report);
                    }
                    report = this.m_mergeHelper.mergeAllMachines(report, ip);
                    new TransactionTrendGraphBuilder().buildTrendGraph(model, payload, report);
                    break;
                }
                case 4: {
                    TransactionReport report = this.getHourlyGraphReport(model, payload);
                    if ("All".equalsIgnoreCase(ipAddress)) {
                        this.buildDistributionInfo(model, type, name, report);
                    }
                    if (name == null || name.length() == 0) {
                        name = "All";
                    }
                    report = this.m_mergeHelper.mergeAllNames(report, ip, name);
                    model.setReport(report);
                    this.buildTransactionNameGraph(model, report, type, name, ip);
                    break;
                }
                case 5: {
                    ReportQueryHelp.set((boolean)false, (String)type, (String)queryName, (String)ip);
                    TransactionReport report = this.getHourlyReport(payload);
                    report = this.filterReportByGroup(report, domain, group);
                    report = this.m_mergeHelper.mergeAllMachines(report, ipAddress);
                    if (report == null) break;
                    model.setReport(report);
                    this.buildTransactionMetaInfo(model, payload, report);
                    break;
                }
                case 6: {
                    ReportQueryHelp.set((boolean)false, (String)type, (String)queryName, (String)ip);
                    TransactionReport report = (TransactionReport)this.m_reportService.queryReport(domain, payload.getHistoryStartDate(), payload.getHistoryEndDate());
                    report = this.filterReportByGroup(report, domain, group);
                    report = this.m_mergeHelper.mergeAllMachines(report, ipAddress);
                    if (report == null) break;
                    model.setReport(report);
                    this.buildTransactionMetaInfo(model, payload, report);
                    break;
                }
                case 7: {
                    TransactionReport report = this.getHourlyGraphReport(model, payload);
                    report = this.filterReportByGroup(report, domain, group);
                    this.buildDistributionInfo(model, type, name, report);
                    if (name == null || name.length() == 0) {
                        name = "All";
                    }
                    report = this.m_mergeHelper.mergeAllNames(report, ip, name);
                    model.setReport(report);
                    this.buildTransactionNameGraph(model, report, type, name, ip);
                    break;
                }
                case 8: {
                    TransactionReport report = (TransactionReport)this.m_reportService.queryReport(domain, start, end);
                    report = this.filterReportByGroup(report, domain, group);
                    this.buildDistributionInfo(model, type, name, report);
                    report = this.m_mergeHelper.mergeAllMachines(report, ip);
                    new TransactionTrendGraphBuilder().buildTrendGraph(model, payload, report);
                }
            }
            if (payload.isXml()) {
                this.m_xmlViewer.view(ctx, model);
            } else {
                this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
            }
        }
        finally {
            ReportQueryHelp.clear();
        }
    }

    private void normalize(Model model, Payload payload) {
        String queryName;
        this.m_normalizePayload.normalize((AbstractReportModel)model, (AbstractReportPayload)payload);
        model.setPage((Page)ReportPage.TRANSACTION);
        model.setAction((org.unidal.web.mvc.Action)payload.getAction());
        if (StringUtils.isEmpty((String)payload.getType())) {
            payload.setType(null);
        }
        if ((queryName = payload.getQueryName()) != null) {
            model.setQueryName(queryName);
        } else {
            payload.setQueryName(null);
        }
    }
}

