/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.transaction.TransactionReportMerger;
import com.dianping.cat.consumer.transaction.model.IEntity;
import com.dianping.cat.consumer.transaction.model.IVisitor;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.transform.DefaultSaxParser;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.ReportBucket;
import com.dianping.cat.report.ReportBucketManager;
import com.dianping.cat.report.page.transaction.ReportQueryHelp;
import com.dianping.cat.report.page.transaction.service.LocalTransactionService;
import com.dianping.cat.report.service.LocalModelService;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.Date;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=LocalModelService.class, value="transaction")
public class LocalTransactionService
extends LocalModelService<TransactionReport> {
    public static final String ID = "transaction";
    @Inject
    private ReportBucketManager m_bucketManager;

    public LocalTransactionService() {
        super(ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)(this.getClass().getSimpleName() + ".buildReport"));
        try {
            List reports = super.getReport(period, domain);
            TransactionReport report = null;
            if (reports != null) {
                report = new TransactionReport(domain);
                TransactionReportMerger merger = new TransactionReportMerger(report);
                for (TransactionReport tmp : reports) {
                    tmp.accept((IVisitor)merger);
                }
            }
            if ((report == null || report.getIps().isEmpty()) && period.isLast()) {
                long startTime = request.getStartTime();
                report = this.getReportFromLocalDisk(startTime, domain);
            }
            ReportQueryHelp.removeReportFields((TransactionReport)report);
            String string = this.filterReport(payload, report);
            return string;
        }
        finally {
            t.setStatus("0");
            t.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String filterReport(ApiPayload payload, TransactionReport report) {
        String xml;
        String type = payload.getType();
        String name = payload.getName();
        String ip = payload.getIpAddress();
        int min = payload.getMin();
        int max = payload.getMax();
        Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)(this.getClass().getSimpleName() + ".filterReport"));
        try {
            TransactionReportFilter filter = new TransactionReportFilter(type, name, ip, min, max);
            xml = filter.buildXml((IEntity)report);
        }
        catch (Exception e) {
            TransactionReportFilter filter = new TransactionReportFilter(type, name, ip, min, max);
            xml = filter.buildXml((IEntity)report);
        }
        finally {
            t.setStatus("0");
            t.complete();
        }
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionReport getReportFromLocalDisk(long timestamp, String domain) throws Exception {
        Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)(this.getClass().getSimpleName() + ".getReportFromLocalDisk"));
        try {
            TransactionReport report = new TransactionReport(domain);
            TransactionReportMerger merger = new TransactionReportMerger(report);
            report.setStartTime(new Date(timestamp));
            report.setEndTime(new Date(timestamp + 3600000L - 1L));
            for (int i = 0; i < this.getAnalyzerCount(); ++i) {
                ReportBucket bucket = null;
                try {
                    String xml;
                    Transaction t1 = Cat.newTransaction((String)"TransactionReportService", (String)"BucketManager.getReportBucket");
                    try {
                        bucket = this.m_bucketManager.getReportBucket(timestamp, ID, i);
                        t1.setStatus("0");
                    }
                    finally {
                        t1.complete();
                    }
                    Transaction t2 = Cat.newTransaction((String)"TransactionReportService", (String)"ReportBucket.findById");
                    try {
                        xml = bucket.findById(domain);
                        t2.setStatus("0");
                    }
                    finally {
                        t2.complete();
                    }
                    if (xml != null) {
                        TransactionReport tmp = DefaultSaxParser.parse((String)xml);
                        ReportQueryHelp.removeReportFields((TransactionReport)tmp);
                        tmp.accept((IVisitor)merger);
                    }
                    if (bucket == null) continue;
                }
                catch (Throwable throwable) {
                    if (bucket != null) {
                        this.m_bucketManager.closeBucket(bucket);
                    }
                    throw throwable;
                }
                this.m_bucketManager.closeBucket(bucket);
            }
            t.setStatus("0");
            TransactionReport transactionReport = report;
            return transactionReport;
        }
        finally {
            t.complete();
        }
    }
}

