/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction.service;

import com.dianping.cat.Cat;
import com.dianping.cat.consumer.transaction.TransactionReportMerger;
import com.dianping.cat.consumer.transaction.model.IVisitor;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.transform.DefaultNativeParser;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.core.dal.DailyReportContent;
import com.dianping.cat.core.dal.DailyReportContentEntity;
import com.dianping.cat.core.dal.DailyReportEntity;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentEntity;
import com.dianping.cat.core.dal.HourlyReportEntity;
import com.dianping.cat.core.dal.MonthlyReport;
import com.dianping.cat.core.dal.MonthlyReportContent;
import com.dianping.cat.core.dal.MonthlyReportContentEntity;
import com.dianping.cat.core.dal.MonthlyReportEntity;
import com.dianping.cat.core.dal.WeeklyReport;
import com.dianping.cat.core.dal.WeeklyReportContent;
import com.dianping.cat.core.dal.WeeklyReportContentEntity;
import com.dianping.cat.core.dal.WeeklyReportEntity;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.page.transaction.ReportQueryHelp;
import com.dianping.cat.report.page.transaction.service.TransactionReportService;
import com.dianping.cat.report.service.AbstractReportService;
import java.util.Date;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Named;

@Named
public class TransactionReportService
extends AbstractReportService<TransactionReport> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionReport convert(TransactionReport report) {
        Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)(this.getClass().getSimpleName() + ".convert"));
        try {
            Date start = report.getStartTime();
            Date end = report.getEndTime();
            try {
                if (start != null && end != null) {
                    TpsStatistics statistics = new TpsStatistics(this, (double)(end.getTime() - start.getTime()) / 1000.0);
                    report.accept((IVisitor)statistics);
                }
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
            AllMachineRemover remover = new AllMachineRemover(this);
            report.accept((IVisitor)remover);
            GraphTrendParser graphTrendParser = new GraphTrendParser(this);
            report.accept((IVisitor)graphTrendParser);
            ReportQueryHelp.removeReportFields((TransactionReport)report);
            t.setStatus("0");
            TransactionReport transactionReport = report;
            return transactionReport;
        }
        finally {
            t.complete();
        }
    }

    public TransactionReport makeReport(String domain, Date start, Date end) {
        TransactionReport report = new TransactionReport(domain);
        report.setStartTime(start);
        report.setEndTime(end);
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionReport queryDailyReport(String domain, Date start, Date end) {
        TransactionReportMerger merger = new TransactionReportMerger(new TransactionReport(domain));
        long endTime = end.getTime();
        String name = "transaction";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 86400000L) {
            try {
                DailyReport report = this.m_dailyReportDao.findByDomainNamePeriod(domain, name, new Date(startTime), DailyReportEntity.READSET_FULL);
                TransactionReport reportModel = this.queryFromDailyBinary(report.getId(), domain);
                Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)"reportModel.accept");
                try {
                    reportModel.accept((IVisitor)merger);
                    t.setStatus("0");
                    continue;
                }
                finally {
                    t.complete();
                }
            }
            catch (DalNotFoundException report) {
                continue;
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
        }
        TransactionReport transactionReport = merger.getTransactionReport();
        transactionReport.setStartTime(start);
        transactionReport.setEndTime(end);
        return this.convert(transactionReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionReport queryFromDailyBinary(int id, String domain) throws DalException {
        DailyReportContent content = this.m_dailyReportContentDao.findByPK(id, DailyReportContentEntity.READSET_FULL);
        if (content != null) {
            Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)"parseDailyBinary");
            try {
                TransactionReport report = DefaultNativeParser.parse((byte[])content.getContent());
                ReportQueryHelp.removeReportFields((TransactionReport)report);
                t.setStatus("0");
                TransactionReport transactionReport = report;
                return transactionReport;
            }
            finally {
                t.complete();
            }
        }
        return new TransactionReport(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionReport queryFromHourlyBinary(int id, Date period, String domain) throws DalException {
        HourlyReportContent content = this.m_hourlyReportContentDao.findByPK(id, period, HourlyReportContentEntity.READSET_CONTENT);
        if (content != null) {
            Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)"parseHourlyBinary");
            try {
                TransactionReport report = DefaultNativeParser.parse((byte[])content.getContent());
                ReportQueryHelp.removeReportFields((TransactionReport)report);
                t.setStatus("0");
                TransactionReport transactionReport = report;
                return transactionReport;
            }
            finally {
                t.complete();
            }
        }
        return new TransactionReport(domain);
    }

    private TransactionReport queryFromMonthlyBinary(int id, String domain) throws DalException {
        MonthlyReportContent content = this.m_monthlyReportContentDao.findByPK(id, MonthlyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new TransactionReport(domain);
    }

    private TransactionReport queryFromWeeklyBinary(int id, String domain) throws DalException {
        WeeklyReportContent content = this.m_weeklyReportContentDao.findByPK(id, WeeklyReportContentEntity.READSET_FULL);
        if (content != null) {
            return DefaultNativeParser.parse((byte[])content.getContent());
        }
        return new TransactionReport(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionReport queryHourlyReport(String domain, Date start, Date end) {
        TransactionReportMerger merger = new TransactionReportMerger(new TransactionReport(domain));
        long endTime = end.getTime();
        String name = "transaction";
        for (long startTime = start.getTime(); startTime < endTime; startTime += 3600000L) {
            List reports = null;
            try {
                reports = this.m_hourlyReportDao.findAllByDomainNamePeriod(new Date(startTime), domain, name, HourlyReportEntity.READSET_FULL);
            }
            catch (DalException e) {
                Cat.logError((Throwable)e);
            }
            if (reports == null) continue;
            for (HourlyReport report : reports) {
                try {
                    TransactionReport reportModel = this.queryFromHourlyBinary(report.getId(), report.getPeriod(), domain);
                    Transaction t = Cat.newTransaction((String)"TransactionReportService", (String)"reportModel.accept");
                    try {
                        reportModel.accept((IVisitor)merger);
                        t.setStatus("0");
                    }
                    finally {
                        t.complete();
                    }
                }
                catch (DalNotFoundException reportModel) {
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
            }
        }
        TransactionReport transactionReport = merger.getTransactionReport();
        transactionReport.setStartTime(start);
        transactionReport.setEndTime(new Date(end.getTime() - 1L));
        return this.convert(transactionReport);
    }

    public TransactionReport queryMonthlyReport(String domain, Date start) {
        TransactionReport transactionReport = new TransactionReport(domain);
        try {
            MonthlyReport entity = this.m_monthlyReportDao.findReportByDomainNamePeriod(start, domain, "transaction", MonthlyReportEntity.READSET_FULL);
            transactionReport = this.queryFromMonthlyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return this.convert(transactionReport);
    }

    public TransactionReport queryWeeklyReport(String domain, Date start) {
        TransactionReport transactionReport = new TransactionReport(domain);
        try {
            WeeklyReport entity = this.m_weeklyReportDao.findReportByDomainNamePeriod(start, domain, "transaction", WeeklyReportEntity.READSET_FULL);
            transactionReport = this.queryFromWeeklyBinary(entity.getId(), domain);
        }
        catch (DalNotFoundException entity) {
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return this.convert(transactionReport);
    }
}

