/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.page.transaction.transform;

import com.dianping.cat.consumer.transaction.model.entity.Machine;
import com.dianping.cat.consumer.transaction.model.entity.TransactionName;
import com.dianping.cat.consumer.transaction.model.entity.TransactionType;
import com.dianping.cat.consumer.transaction.model.transform.BaseVisitor;
import com.dianping.cat.report.graph.PieChart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.unidal.lookup.util.StringUtils;

public class PieGraphChartVisitor
extends BaseVisitor {
    private String m_type;
    private String m_name;
    private Map<String, Long> m_items = new HashMap();
    private String m_ip;

    public PieGraphChartVisitor(String type, String name) {
        this.m_type = type;
        this.m_name = name;
    }

    public PieChart getPieChart() {
        PieChart chart = new PieChart();
        ArrayList<PieChart.Item> items = new ArrayList<PieChart.Item>();
        for (Map.Entry entry : this.m_items.entrySet()) {
            PieChart.Item item = new PieChart.Item();
            item.setNumber((double)((Long)entry.getValue()).longValue()).setTitle((String)entry.getKey());
            items.add(item);
        }
        chart.addItems(items);
        return chart;
    }

    public void visitMachine(Machine machine) {
        if (!"All".equalsIgnoreCase(machine.getIp())) {
            this.m_ip = machine.getIp();
            block0: for (TransactionType type : machine.getTypes().values()) {
                if (this.m_type == null || !this.m_type.equals(type.getId())) continue;
                if (StringUtils.isEmpty((String)this.m_name)) {
                    this.m_items.put(this.m_ip, type.getTotalCount());
                    break;
                }
                for (TransactionName name : type.getNames().values()) {
                    if (!this.m_name.equals(name.getId())) continue;
                    this.m_items.put(this.m_ip, name.getTotalCount());
                    break block0;
                }
            }
        }
    }
}

