/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.core.dal.Task;
import com.dianping.cat.core.dal.TaskDao;
import com.dianping.cat.core.dal.TaskEntity;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.report.task.ReportFacade;
import com.dianping.cat.report.task.TaskConsumer;
import java.util.Date;
import java.util.concurrent.locks.LockSupport;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class DefaultTaskConsumer
extends TaskConsumer {
    @Inject
    private ReportFacade m_reportFacade;
    @Inject
    private TaskDao m_taskDao;

    protected Task findDoingTask(String ip) {
        Task task = null;
        try {
            task = this.m_taskDao.findByStatusConsumer(2, ip, TaskEntity.READSET_FULL);
        }
        catch (DalException dalException) {
            // empty catch block
        }
        return task;
    }

    protected Task findTodoTask() {
        Task task = null;
        try {
            task = this.m_taskDao.findByStatusConsumer(1, null, TaskEntity.READSET_FULL);
        }
        catch (DalException dalException) {
            // empty catch block
        }
        return task;
    }

    public String getName() {
        return "Task-Consumer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processTask(Task doing) {
        boolean result = false;
        Transaction t = Cat.newTransaction((String)"Task", (String)doing.getReportName());
        t.addData(doing.toString());
        try {
            result = this.m_reportFacade.builderReport(doing);
            t.setStatus("0");
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
            t.setStatus(e);
        }
        finally {
            t.complete();
        }
        return result;
    }

    public void shutdown() {
    }

    protected void taskNotFoundDuration() {
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void taskRetryDuration() {
        LockSupport.parkNanos(2000000000L);
    }

    protected boolean updateDoingToDone(Task doing) {
        doing.setStatus(3);
        doing.setEndDate(new Date());
        try {
            return this.m_taskDao.updateDoingToDone(doing, TaskEntity.UPDATESET_FULL) == 1;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return true;
        }
    }

    protected boolean updateDoingToFailure(Task doing) {
        doing.setStatus(4);
        doing.setEndDate(new Date());
        try {
            return this.m_taskDao.updateDoingToFail(doing, TaskEntity.UPDATESET_FULL) == 1;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    protected boolean updateTodoToDoing(Task todo) {
        todo.setStatus(2);
        todo.setConsumer(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        todo.setStartDate(new Date());
        try {
            return this.m_taskDao.updateTodoToDoing(todo, TaskEntity.UPDATESET_FULL) == 1;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }
}

