/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.core.dal.Task;
import java.util.Calendar;
import org.unidal.helper.Threads;

public abstract class TaskConsumer
implements Threads.Task {
    public static final int STATUS_TODO = 1;
    public static final int STATUS_DOING = 2;
    public static final int STATUS_DONE = 3;
    public static final int STATUS_FAIL = 4;
    private static final int MAX_TODO_RETRY_TIMES = 1;
    private long m_nanos = 2000000000L;
    private volatile boolean m_running = true;
    private volatile boolean m_stopped = false;

    public boolean checkTime() {
        Calendar cal = Calendar.getInstance();
        int minute = cal.get(12);
        return minute >= 10;
    }

    protected abstract Task findDoingTask(String var1);

    protected abstract Task findTodoTask();

    protected String getLoaclIp() {
        return NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
    }

    protected long getSleepTime() {
        return this.m_nanos;
    }

    public boolean isStopped() {
        return this.m_stopped;
    }

    protected abstract boolean processTask(Task var1);

    public void run() {
        String localIp = this.getLoaclIp();
        while (this.m_running) {
            try {
                if (this.checkTime()) {
                    Task task = this.findDoingTask(localIp);
                    if (task == null) {
                        task = this.findTodoTask();
                    }
                    boolean again = false;
                    if (task != null) {
                        try {
                            task.setConsumer(localIp);
                            if (task.getStatus() != 2 && !this.updateTodoToDoing(task)) continue;
                            int retryTimes = 0;
                            while (!this.processTask(task)) {
                                if (++retryTimes < 1) {
                                    this.taskRetryDuration();
                                    continue;
                                }
                                this.updateDoingToFailure(task);
                                again = true;
                                break;
                            }
                            if (again) continue;
                            this.updateDoingToDone(task);
                        }
                        catch (Throwable e) {
                            Cat.logError((String)task.toString(), (Throwable)e);
                        }
                        continue;
                    }
                    this.taskNotFoundDuration();
                    continue;
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException task) {
                }
            }
            catch (Throwable e) {
                Cat.logError((Throwable)e);
            }
        }
        this.m_stopped = true;
    }

    public void stop() {
        this.m_running = false;
    }

    protected abstract void taskNotFoundDuration();

    protected abstract void taskRetryDuration();

    protected abstract boolean updateDoingToDone(Task var1);

    protected abstract boolean updateDoingToFailure(Task var1);

    protected abstract boolean updateTodoToDoing(Task var1);
}

